@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.MonitoringSettingPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Monitoring Setting properties payload
 * @property appInsightsInstrumentationKey Target application insight instrumentation key, null or whitespace include empty will disable monitoringSettings
 * @property appInsightsSamplingRate Indicates the sampling rate of application insight agent, should be in range [0&#46;0, 100&#46;0]
 * @property error Error when apply Monitoring Setting changes.
 * @property traceEnabled Indicates whether enable the trace functionality, which will be deprecated since api version 2020-11-01-preview. Please leverage appInsightsInstrumentationKey to indicate if monitoringSettings enabled or not
 */
public data class MonitoringSettingPropertiesArgs(
    public val appInsightsInstrumentationKey: Output<String>? = null,
    public val appInsightsSamplingRate: Output<Double>? = null,
    public val error: Output<ErrorArgs>? = null,
    public val traceEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.MonitoringSettingPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.MonitoringSettingPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.MonitoringSettingPropertiesArgs.builder()
            .appInsightsInstrumentationKey(appInsightsInstrumentationKey?.applyValue({ args0 -> args0 }))
            .appInsightsSamplingRate(appInsightsSamplingRate?.applyValue({ args0 -> args0 }))
            .error(error?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .traceEnabled(traceEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitoringSettingPropertiesArgs].
 */
@PulumiTagMarker
public class MonitoringSettingPropertiesArgsBuilder internal constructor() {
    private var appInsightsInstrumentationKey: Output<String>? = null

    private var appInsightsSamplingRate: Output<Double>? = null

    private var error: Output<ErrorArgs>? = null

    private var traceEnabled: Output<Boolean>? = null

    /**
     * @param value Target application insight instrumentation key, null or whitespace include empty will disable monitoringSettings
     */
    @JvmName("elmlimgunrguahxp")
    public suspend fun appInsightsInstrumentationKey(`value`: Output<String>) {
        this.appInsightsInstrumentationKey = value
    }

    /**
     * @param value Indicates the sampling rate of application insight agent, should be in range [0&#46;0, 100&#46;0]
     */
    @JvmName("xuveqxeynncomjky")
    public suspend fun appInsightsSamplingRate(`value`: Output<Double>) {
        this.appInsightsSamplingRate = value
    }

    /**
     * @param value Error when apply Monitoring Setting changes.
     */
    @JvmName("arxpdwljlicasggl")
    public suspend fun error(`value`: Output<ErrorArgs>) {
        this.error = value
    }

    /**
     * @param value Indicates whether enable the trace functionality, which will be deprecated since api version 2020-11-01-preview. Please leverage appInsightsInstrumentationKey to indicate if monitoringSettings enabled or not
     */
    @JvmName("gnmwgqxvlyfayvjv")
    public suspend fun traceEnabled(`value`: Output<Boolean>) {
        this.traceEnabled = value
    }

    /**
     * @param value Target application insight instrumentation key, null or whitespace include empty will disable monitoringSettings
     */
    @JvmName("sxkexrgepdhsynge")
    public suspend fun appInsightsInstrumentationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appInsightsInstrumentationKey = mapped
    }

    /**
     * @param value Indicates the sampling rate of application insight agent, should be in range [0&#46;0, 100&#46;0]
     */
    @JvmName("yyidwpxmfdpnmfjm")
    public suspend fun appInsightsSamplingRate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appInsightsSamplingRate = mapped
    }

    /**
     * @param value Error when apply Monitoring Setting changes.
     */
    @JvmName("krapgibnsrfkewls")
    public suspend fun error(`value`: ErrorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.error = mapped
    }

    /**
     * @param argument Error when apply Monitoring Setting changes.
     */
    @JvmName("yketcgppbxwuvyio")
    public suspend fun error(argument: suspend ErrorArgsBuilder.() -> Unit) {
        val toBeMapped = ErrorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.error = mapped
    }

    /**
     * @param value Indicates whether enable the trace functionality, which will be deprecated since api version 2020-11-01-preview. Please leverage appInsightsInstrumentationKey to indicate if monitoringSettings enabled or not
     */
    @JvmName("oqcbisnvcjhbmrvd")
    public suspend fun traceEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.traceEnabled = mapped
    }

    internal fun build(): MonitoringSettingPropertiesArgs = MonitoringSettingPropertiesArgs(
        appInsightsInstrumentationKey = appInsightsInstrumentationKey,
        appInsightsSamplingRate = appInsightsSamplingRate,
        error = error,
        traceEnabled = traceEnabled,
    )
}
