@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ProbeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Probe describes a health check to be performed against an App Instance to determine whether it is alive or ready to receive traffic.
 * @property disableProbe Indicate whether the probe is disabled.
 * @property failureThreshold Minimum consecutive failures for the probe to be considered failed after having succeeded. Minimum value is 1.
 * @property initialDelaySeconds Number of seconds after the App Instance has started before probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
 * @property periodSeconds How often (in seconds) to perform the probe. Minimum value is 1.
 * @property probeAction The action of the probe.
 * @property successThreshold Minimum consecutive successes for the probe to be considered successful after having failed. Must be 1 for liveness and startup. Minimum value is 1.
 * @property timeoutSeconds Number of seconds after which the probe times out. Minimum value is 1.
 */
public data class ProbeArgs(
    public val disableProbe: Output<Boolean>,
    public val failureThreshold: Output<Int>? = null,
    public val initialDelaySeconds: Output<Int>? = null,
    public val periodSeconds: Output<Int>? = null,
    public val probeAction: Output<Any>? = null,
    public val successThreshold: Output<Int>? = null,
    public val timeoutSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ProbeArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ProbeArgs =
        com.pulumi.azurenative.appplatform.inputs.ProbeArgs.builder()
            .disableProbe(disableProbe.applyValue({ args0 -> args0 }))
            .failureThreshold(failureThreshold?.applyValue({ args0 -> args0 }))
            .initialDelaySeconds(initialDelaySeconds?.applyValue({ args0 -> args0 }))
            .periodSeconds(periodSeconds?.applyValue({ args0 -> args0 }))
            .probeAction(probeAction?.applyValue({ args0 -> args0 }))
            .successThreshold(successThreshold?.applyValue({ args0 -> args0 }))
            .timeoutSeconds(timeoutSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProbeArgs].
 */
@PulumiTagMarker
public class ProbeArgsBuilder internal constructor() {
    private var disableProbe: Output<Boolean>? = null

    private var failureThreshold: Output<Int>? = null

    private var initialDelaySeconds: Output<Int>? = null

    private var periodSeconds: Output<Int>? = null

    private var probeAction: Output<Any>? = null

    private var successThreshold: Output<Int>? = null

    private var timeoutSeconds: Output<Int>? = null

    /**
     * @param value Indicate whether the probe is disabled.
     */
    @JvmName("pgbhgwjrbohbejqs")
    public suspend fun disableProbe(`value`: Output<Boolean>) {
        this.disableProbe = value
    }

    /**
     * @param value Minimum consecutive failures for the probe to be considered failed after having succeeded. Minimum value is 1.
     */
    @JvmName("dvsgfmcribiqynkl")
    public suspend fun failureThreshold(`value`: Output<Int>) {
        this.failureThreshold = value
    }

    /**
     * @param value Number of seconds after the App Instance has started before probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    @JvmName("fuajngmiyjvrqait")
    public suspend fun initialDelaySeconds(`value`: Output<Int>) {
        this.initialDelaySeconds = value
    }

    /**
     * @param value How often (in seconds) to perform the probe. Minimum value is 1.
     */
    @JvmName("lkmfmpuhwknstqin")
    public suspend fun periodSeconds(`value`: Output<Int>) {
        this.periodSeconds = value
    }

    /**
     * @param value The action of the probe.
     */
    @JvmName("vqkhtblfgcravmpe")
    public suspend fun probeAction(`value`: Output<Any>) {
        this.probeAction = value
    }

    /**
     * @param value Minimum consecutive successes for the probe to be considered successful after having failed. Must be 1 for liveness and startup. Minimum value is 1.
     */
    @JvmName("tpciwahffkxbqyvd")
    public suspend fun successThreshold(`value`: Output<Int>) {
        this.successThreshold = value
    }

    /**
     * @param value Number of seconds after which the probe times out. Minimum value is 1.
     */
    @JvmName("wdsilirvxvhgnwuq")
    public suspend fun timeoutSeconds(`value`: Output<Int>) {
        this.timeoutSeconds = value
    }

    /**
     * @param value Indicate whether the probe is disabled.
     */
    @JvmName("scefvcjvmotyppns")
    public suspend fun disableProbe(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disableProbe = mapped
    }

    /**
     * @param value Minimum consecutive failures for the probe to be considered failed after having succeeded. Minimum value is 1.
     */
    @JvmName("wygpitsivcmalswd")
    public suspend fun failureThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureThreshold = mapped
    }

    /**
     * @param value Number of seconds after the App Instance has started before probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    @JvmName("khtmsaorsyaqlnfp")
    public suspend fun initialDelaySeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialDelaySeconds = mapped
    }

    /**
     * @param value How often (in seconds) to perform the probe. Minimum value is 1.
     */
    @JvmName("jmtyjuqogigbipof")
    public suspend fun periodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodSeconds = mapped
    }

    /**
     * @param value The action of the probe.
     */
    @JvmName("cpvvlmabffqoqdxy")
    public suspend fun probeAction(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probeAction = mapped
    }

    /**
     * @param value Minimum consecutive successes for the probe to be considered successful after having failed. Must be 1 for liveness and startup. Minimum value is 1.
     */
    @JvmName("sxqbvalafchmnevq")
    public suspend fun successThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successThreshold = mapped
    }

    /**
     * @param value Number of seconds after which the probe times out. Minimum value is 1.
     */
    @JvmName("ywttafcvbdirqymv")
    public suspend fun timeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutSeconds = mapped
    }

    internal fun build(): ProbeArgs = ProbeArgs(
        disableProbe = disableProbe ?: throw PulumiNullFieldException("disableProbe"),
        failureThreshold = failureThreshold,
        initialDelaySeconds = initialDelaySeconds,
        periodSeconds = periodSeconds,
        probeAction = probeAction,
        successThreshold = successThreshold,
        timeoutSeconds = timeoutSeconds,
    )
}
