@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ResourceRequestsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Deployment resource request payload
 * @property cpu Required CPU. 1 core can be represented by 1 or 1000m. This should be 500m or 1 for Basic tier, and {500m, 1, 2, 3, 4} for Standard tier.
 * @property memory Required memory. 1 GB can be represented by 1Gi or 1024Mi. This should be {512Mi, 1Gi, 2Gi} for Basic tier, and {512Mi, 1Gi, 2Gi, ..., 8Gi} for Standard tier.
 */
public data class ResourceRequestsArgs(
    public val cpu: Output<String>? = null,
    public val memory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ResourceRequestsArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ResourceRequestsArgs =
        com.pulumi.azurenative.appplatform.inputs.ResourceRequestsArgs.builder()
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .memory(memory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceRequestsArgs].
 */
@PulumiTagMarker
public class ResourceRequestsArgsBuilder internal constructor() {
    private var cpu: Output<String>? = null

    private var memory: Output<String>? = null

    /**
     * @param value Required CPU. 1 core can be represented by 1 or 1000m. This should be 500m or 1 for Basic tier, and {500m, 1, 2, 3, 4} for Standard tier.
     */
    @JvmName("klhfxeysgkvrmumm")
    public suspend fun cpu(`value`: Output<String>) {
        this.cpu = value
    }

    /**
     * @param value Required memory. 1 GB can be represented by 1Gi or 1024Mi. This should be {512Mi, 1Gi, 2Gi} for Basic tier, and {512Mi, 1Gi, 2Gi, ..., 8Gi} for Standard tier.
     */
    @JvmName("rvnbohbxgqpseafa")
    public suspend fun memory(`value`: Output<String>) {
        this.memory = value
    }

    /**
     * @param value Required CPU. 1 core can be represented by 1 or 1000m. This should be 500m or 1 for Basic tier, and {500m, 1, 2, 3, 4} for Standard tier.
     */
    @JvmName("tgchqxhyrympyjcg")
    public suspend fun cpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value Required memory. 1 GB can be represented by 1Gi or 1024Mi. This should be {512Mi, 1Gi, 2Gi} for Basic tier, and {512Mi, 1Gi, 2Gi, ..., 8Gi} for Standard tier.
     */
    @JvmName("yrkipogybrcaffrp")
    public suspend fun memory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    internal fun build(): ResourceRequestsArgs = ResourceRequestsArgs(
        cpu = cpu,
        memory = memory,
    )
}
