@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.SsoPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Single sign-on related configuration
 * @property clientId The public identifier for the application
 * @property clientSecret The secret known only to the application and the authorization server
 * @property issuerUri The URI of Issuer Identifier
 * @property scope It defines the specific actions applications can be allowed to do on a user's behalf
 */
public data class SsoPropertiesArgs(
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val issuerUri: Output<String>? = null,
    public val scope: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.SsoPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.SsoPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.SsoPropertiesArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .issuerUri(issuerUri?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SsoPropertiesArgs].
 */
@PulumiTagMarker
public class SsoPropertiesArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var issuerUri: Output<String>? = null

    private var scope: Output<List<String>>? = null

    /**
     * @param value The public identifier for the application
     */
    @JvmName("vrxedhvpbeyxcpxy")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The secret known only to the application and the authorization server
     */
    @JvmName("aurmrswhjkucumyx")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value The URI of Issuer Identifier
     */
    @JvmName("hipdsumafasifoes")
    public suspend fun issuerUri(`value`: Output<String>) {
        this.issuerUri = value
    }

    /**
     * @param value It defines the specific actions applications can be allowed to do on a user's behalf
     */
    @JvmName("ypnrogjjrsihiooh")
    public suspend fun scope(`value`: Output<List<String>>) {
        this.scope = value
    }

    @JvmName("pxxukarwwqetgtao")
    public suspend fun scope(vararg values: Output<String>) {
        this.scope = Output.all(values.asList())
    }

    /**
     * @param values It defines the specific actions applications can be allowed to do on a user's behalf
     */
    @JvmName("dvyicnpobqrukvmn")
    public suspend fun scope(values: List<Output<String>>) {
        this.scope = Output.all(values)
    }

    /**
     * @param value The public identifier for the application
     */
    @JvmName("jaixunygrhqthupe")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The secret known only to the application and the authorization server
     */
    @JvmName("fpxdfwcqwypcqtxk")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The URI of Issuer Identifier
     */
    @JvmName("ttvfqgpkwjjrcump")
    public suspend fun issuerUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuerUri = mapped
    }

    /**
     * @param value It defines the specific actions applications can be allowed to do on a user's behalf
     */
    @JvmName("eyeqcxxsbmlokfvm")
    public suspend fun scope(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param values It defines the specific actions applications can be allowed to do on a user's behalf
     */
    @JvmName("fhmfjnlnngnkvgqx")
    public suspend fun scope(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): SsoPropertiesArgs = SsoPropertiesArgs(
        clientId = clientId,
        clientSecret = clientSecret,
        issuerUri = issuerUri,
        scope = scope,
    )
}
