@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.TemporaryDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Temporary disk payload
 * @property mountPath Mount path of the temporary disk
 * @property sizeInGB Size of the temporary disk in GB
 */
public data class TemporaryDiskArgs(
    public val mountPath: Output<String>? = null,
    public val sizeInGB: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.TemporaryDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.TemporaryDiskArgs =
        com.pulumi.azurenative.appplatform.inputs.TemporaryDiskArgs.builder()
            .mountPath(mountPath?.applyValue({ args0 -> args0 }))
            .sizeInGB(sizeInGB?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemporaryDiskArgs].
 */
@PulumiTagMarker
public class TemporaryDiskArgsBuilder internal constructor() {
    private var mountPath: Output<String>? = null

    private var sizeInGB: Output<Int>? = null

    /**
     * @param value Mount path of the temporary disk
     */
    @JvmName("fibtjugsokyctbbd")
    public suspend fun mountPath(`value`: Output<String>) {
        this.mountPath = value
    }

    /**
     * @param value Size of the temporary disk in GB
     */
    @JvmName("lsakqimbxvnfbtbc")
    public suspend fun sizeInGB(`value`: Output<Int>) {
        this.sizeInGB = value
    }

    /**
     * @param value Mount path of the temporary disk
     */
    @JvmName("lccpedohktirnvbi")
    public suspend fun mountPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountPath = mapped
    }

    /**
     * @param value Size of the temporary disk in GB
     */
    @JvmName("hkepbfwokwsgybmh")
    public suspend fun sizeInGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeInGB = mapped
    }

    internal fun build(): TemporaryDiskArgs = TemporaryDiskArgs(
        mountPath = mountPath,
        sizeInGB = sizeInGB,
    )
}
