@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Auth setting for SSH auth.
 * @property authType The type of the auth setting.
 * Expected value is 'SSH'.
 */
public data class AcceleratorSshSettingResponse(
    public val authType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.AcceleratorSshSettingResponse):
            AcceleratorSshSettingResponse = AcceleratorSshSettingResponse(
            authType = javaType.authType(),
        )
    }
}
