@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cpu Cpu allocated to each application accelerator component. 1 core can be represented by 1 or 1000m
 * @property instanceCount Instance count of the application accelerator component.
 * @property memory Memory allocated to each application accelerator component. 1 GB can be represented by 1Gi or 1024Mi.
 */
public data class ApplicationAcceleratorResourceRequestsResponse(
    public val cpu: String,
    public val instanceCount: Int,
    public val memory: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ApplicationAcceleratorResourceRequestsResponse):
            ApplicationAcceleratorResourceRequestsResponse =
            ApplicationAcceleratorResourceRequestsResponse(
                cpu = javaType.cpu(),
                instanceCount = javaType.instanceCount(),
                memory = javaType.memory(),
            )
    }
}
