@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Reference to a build result
 * @property buildResultId Resource id of an existing succeeded build result under the same Spring instance.
 * @property type Type of the source uploaded
 * Expected value is 'BuildResult'.
 * @property version Version of the source
 */
public data class BuildResultUserSourceInfoResponse(
    public val buildResultId: String? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.BuildResultUserSourceInfoResponse):
            BuildResultUserSourceInfoResponse = BuildResultUserSourceInfoResponse(
            buildResultId = javaType.buildResultId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
