@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Build service agent pool size properties
 * @property cpu The cpu property of build service agent pool size
 * @property memory The memory property of build service agent pool size
 * @property name The name of build service agent pool size
 */
public data class BuildServiceAgentPoolSizePropertiesResponse(
    public val cpu: String,
    public val memory: String,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.BuildServiceAgentPoolSizePropertiesResponse):
            BuildServiceAgentPoolSizePropertiesResponse = BuildServiceAgentPoolSizePropertiesResponse(
            cpu = javaType.cpu(),
            memory = javaType.memory(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
