@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Buildpack Binding Launch Properties
 * @property properties Non-sensitive properties for launchProperties
 * @property secrets Sensitive properties for launchProperties
 */
public data class BuildpackBindingLaunchPropertiesResponse(
    public val properties: Map<String, String>? = null,
    public val secrets: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.BuildpackBindingLaunchPropertiesResponse):
            BuildpackBindingLaunchPropertiesResponse = BuildpackBindingLaunchPropertiesResponse(
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            secrets = javaType.secrets().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
