@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Property of git.
 * @property hostKey Public sshKey of git repository.
 * @property hostKeyAlgorithm SshKey algorithm of git repository.
 * @property label Label of the repository
 * @property password Password of git repository basic auth.
 * @property privateKey Private sshKey algorithm of git repository.
 * @property repositories Repositories of git.
 * @property searchPaths Searching path of the repository
 * @property strictHostKeyChecking Strict host key checking or not.
 * @property uri URI of the repository
 * @property username Username of git repository basic auth.
 */
public data class ConfigServerGitPropertyResponse(
    public val hostKey: String? = null,
    public val hostKeyAlgorithm: String? = null,
    public val label: String? = null,
    public val password: String? = null,
    public val privateKey: String? = null,
    public val repositories: List<GitPatternRepositoryResponse>? = null,
    public val searchPaths: List<String>? = null,
    public val strictHostKeyChecking: Boolean? = null,
    public val uri: String,
    public val username: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ConfigServerGitPropertyResponse):
            ConfigServerGitPropertyResponse = ConfigServerGitPropertyResponse(
            hostKey = javaType.hostKey().map({ args0 -> args0 }).orElse(null),
            hostKeyAlgorithm = javaType.hostKeyAlgorithm().map({ args0 -> args0 }).orElse(null),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            privateKey = javaType.privateKey().map({ args0 -> args0 }).orElse(null),
            repositories = javaType.repositories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.GitPatternRepositoryResponse.Companion.toKotlin(args0)
                })
            }),
            searchPaths = javaType.searchPaths().map({ args0 -> args0 }),
            strictHostKeyChecking = javaType.strictHostKeyChecking().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri(),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
