@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Collection of instances belong to the Application Configuration Service
 * @property name Name of the Application Configuration Service instance
 * @property status Status of the Application Configuration Service instance
 */
public data class ConfigurationServiceInstanceResponse(
    public val name: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ConfigurationServiceInstanceResponse):
            ConfigurationServiceInstanceResponse = ConfigurationServiceInstanceResponse(
            name = javaType.name(),
            status = javaType.status(),
        )
    }
}
