@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Container registry resource payload.
 * @property credentials The credentials of the container registry resource.
 * @property provisioningState State of the Container Registry.
 */
public data class ContainerRegistryPropertiesResponse(
    public val credentials: ContainerRegistryBasicCredentialsResponse,
    public val provisioningState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ContainerRegistryPropertiesResponse):
            ContainerRegistryPropertiesResponse = ContainerRegistryPropertiesResponse(
            credentials = javaType.credentials().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.ContainerRegistryBasicCredentialsResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
        )
    }
}
