@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Deployment settings payload
 * @property addonConfigs Collection of addons
 * @property apms Collection of ApmReferences
 * @property containerProbeSettings Container liveness and readiness probe settings
 * @property environmentVariables Collection of environment variables
 * @property livenessProbe Periodic probe of App Instance liveness. App Instance will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
 * @property readinessProbe Periodic probe of App Instance service readiness. App Instance will be removed from service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
 * @property resourceRequests The requested resource quantity for required CPU and Memory. It is recommended that using this field to represent the required CPU and Memory, the old field cpu and memoryInGB will be deprecated later.
 * @property scale Scaling properties for the Azure Spring Apps App Instance.
 * @property startupProbe StartupProbe indicates that the App Instance has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a App Instance's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
 * @property terminationGracePeriodSeconds Optional duration in seconds the App Instance needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the App Instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 90 seconds.
 */
public data class DeploymentSettingsResponse(
    public val addonConfigs: Map<String, Any>? = null,
    public val apms: List<ApmReferenceResponse>? = null,
    public val containerProbeSettings: ContainerProbeSettingsResponse? = null,
    public val environmentVariables: Map<String, String>? = null,
    public val livenessProbe: ProbeResponse? = null,
    public val readinessProbe: ProbeResponse? = null,
    public val resourceRequests: ResourceRequestsResponse? = null,
    public val scale: ScaleResponse? = null,
    public val startupProbe: ProbeResponse? = null,
    public val terminationGracePeriodSeconds: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.DeploymentSettingsResponse):
            DeploymentSettingsResponse = DeploymentSettingsResponse(
            addonConfigs = javaType.addonConfigs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            apms = javaType.apms().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ApmReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            containerProbeSettings = javaType.containerProbeSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ContainerProbeSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            livenessProbe = javaType.livenessProbe().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ProbeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            readinessProbe = javaType.readinessProbe().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ProbeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resourceRequests = javaType.resourceRequests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ResourceRequestsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scale = javaType.scale().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ScaleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            startupProbe = javaType.startupProbe().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ProbeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            terminationGracePeriodSeconds = javaType.terminationGracePeriodSeconds().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
