@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Collection of instances belong to the Dev Tool Portal.
 * @property name Name of the Dev Tool Portal instance.
 * @property status Status of the Dev Tool Portal instance. It can be Pending, Running, Succeeded, Failed, Unknown.
 */
public data class DevToolPortalInstanceResponse(
    public val name: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.DevToolPortalInstanceResponse):
            DevToolPortalInstanceResponse = DevToolPortalInstanceResponse(
            name = javaType.name(),
            status = javaType.status(),
        )
    }
}
