@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Single sign-on related configuration
 * @property clientId The public identifier for the application
 * @property clientSecret The secret known only to the application and the authorization server
 * @property metadataUrl The URI of a JSON file with generic OIDC provider configuration.
 * @property scopes It defines the specific actions applications can be allowed to do on a user's behalf
 */
public data class DevToolPortalSsoPropertiesResponse(
    public val clientId: String? = null,
    public val clientSecret: String? = null,
    public val metadataUrl: String? = null,
    public val scopes: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.DevToolPortalSsoPropertiesResponse):
            DevToolPortalSsoPropertiesResponse = DevToolPortalSsoPropertiesResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 -> args0 }).orElse(null),
            metadataUrl = javaType.metadataUrl().map({ args0 -> args0 }).orElse(null),
            scopes = javaType.scopes().map({ args0 -> args0 }),
        )
    }
}
