@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Properties of the Spring Cloud Gateway Operator.
 * @property cpu Cpu allocated to each Spring Cloud Gateway Operator instance.
 * @property instanceCount Instance count of the Spring Cloud Gateway Operator.
 * @property memory Memory allocated to each Spring Cloud Gateway Operator instance.
 */
public data class GatewayOperatorResourceRequestsResponse(
    public val cpu: String,
    public val instanceCount: Int,
    public val memory: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GatewayOperatorResourceRequestsResponse):
            GatewayOperatorResourceRequestsResponse = GatewayOperatorResourceRequestsResponse(
            cpu = javaType.cpu(),
            instanceCount = javaType.instanceCount(),
            memory = javaType.memory(),
        )
    }
}
