@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Client-Certification Authentication.
 * @property certificateVerification Whether to enable certificate verification or not
 * @property certificates Collection of certificate resource Ids in Azure Spring Apps.
 */
public data class GatewayPropertiesResponseClientAuth(
    public val certificateVerification: String? = null,
    public val certificates: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GatewayPropertiesResponseClientAuth):
            GatewayPropertiesResponseClientAuth = GatewayPropertiesResponseClientAuth(
            certificateVerification = javaType.certificateVerification().map({ args0 -> args0 }).orElse(null),
            certificates = javaType.certificates().map({ args0 -> args0 }),
        )
    }
}
