@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Additional Service settings in vnet injection instance
 * @property dataPlanePublicEndpoint Indicates whether the data plane components(log stream, app connect, remote debugging) in vnet injection instance could be accessed from internet.
 * @property logStreamPublicEndpoint Indicates whether the log stream in vnet injection instance could be accessed from internet.
 */
public data class ServiceVNetAddonsResponse(
    public val dataPlanePublicEndpoint: Boolean? = null,
    public val logStreamPublicEndpoint: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ServiceVNetAddonsResponse):
            ServiceVNetAddonsResponse = ServiceVNetAddonsResponse(
            dataPlanePublicEndpoint = javaType.dataPlanePublicEndpoint().map({ args0 -> args0 }).orElse(null),
            logStreamPublicEndpoint = javaType.logStreamPublicEndpoint().map({ args0 -> args0 }).orElse(null),
        )
    }
}
