@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.attestation.kotlin.inputs

import com.pulumi.azurenative.attestation.inputs.AttestationServiceCreationSpecificParamsArgs.builder
import com.pulumi.azurenative.attestation.kotlin.enums.PublicNetworkAccessType
import com.pulumi.azurenative.attestation.kotlin.enums.TpmAttestationAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Client supplied parameters used to create a new attestation provider.
 * @property policySigningCertificates JSON Web Key Set defining a set of X.509 Certificates that will represent the parent certificate for the signing certificate used for policy operations
 * @property publicNetworkAccess Controls whether traffic from the public network is allowed to access the Attestation Provider APIs.
 * @property tpmAttestationAuthentication The setting that controls whether authentication is enabled or disabled for TPM Attestation REST APIs.
 */
public data class AttestationServiceCreationSpecificParamsArgs(
    public val policySigningCertificates: Output<JSONWebKeySetArgs>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccessType>>? = null,
    public val tpmAttestationAuthentication: Output<Either<String, TpmAttestationAuthenticationType>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.attestation.inputs.AttestationServiceCreationSpecificParamsArgs> {
    override fun toJava():
        com.pulumi.azurenative.attestation.inputs.AttestationServiceCreationSpecificParamsArgs =
        com.pulumi.azurenative.attestation.inputs.AttestationServiceCreationSpecificParamsArgs.builder()
            .policySigningCertificates(
                policySigningCertificates?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .tpmAttestationAuthentication(
                tpmAttestationAuthentication?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [AttestationServiceCreationSpecificParamsArgs].
 */
@PulumiTagMarker
public class AttestationServiceCreationSpecificParamsArgsBuilder internal constructor() {
    private var policySigningCertificates: Output<JSONWebKeySetArgs>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccessType>>? = null

    private var tpmAttestationAuthentication:
        Output<Either<String, TpmAttestationAuthenticationType>>? = null

    /**
     * @param value JSON Web Key Set defining a set of X.509 Certificates that will represent the parent certificate for the signing certificate used for policy operations
     */
    @JvmName("kwxxkptemiqnacub")
    public suspend fun policySigningCertificates(`value`: Output<JSONWebKeySetArgs>) {
        this.policySigningCertificates = value
    }

    /**
     * @param value Controls whether traffic from the public network is allowed to access the Attestation Provider APIs.
     */
    @JvmName("drnrcbbnxkdnvxdt")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccessType>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The setting that controls whether authentication is enabled or disabled for TPM Attestation REST APIs.
     */
    @JvmName("pimttemxyqdlfjsq")
    public suspend
    fun tpmAttestationAuthentication(`value`: Output<Either<String, TpmAttestationAuthenticationType>>) {
        this.tpmAttestationAuthentication = value
    }

    /**
     * @param value JSON Web Key Set defining a set of X.509 Certificates that will represent the parent certificate for the signing certificate used for policy operations
     */
    @JvmName("ufneosqeogigrafi")
    public suspend fun policySigningCertificates(`value`: JSONWebKeySetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policySigningCertificates = mapped
    }

    /**
     * @param argument JSON Web Key Set defining a set of X.509 Certificates that will represent the parent certificate for the signing certificate used for policy operations
     */
    @JvmName("ifljwciexauujifk")
    public suspend
    fun policySigningCertificates(argument: suspend JSONWebKeySetArgsBuilder.() -> Unit) {
        val toBeMapped = JSONWebKeySetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policySigningCertificates = mapped
    }

    /**
     * @param value Controls whether traffic from the public network is allowed to access the Attestation Provider APIs.
     */
    @JvmName("lsopavwxggxgmost")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccessType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Controls whether traffic from the public network is allowed to access the Attestation Provider APIs.
     */
    @JvmName("cdmeoymghiidgfrg")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Controls whether traffic from the public network is allowed to access the Attestation Provider APIs.
     */
    @JvmName("cgmjaaifpcdgirdc")
    public fun publicNetworkAccess(`value`: PublicNetworkAccessType) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The setting that controls whether authentication is enabled or disabled for TPM Attestation REST APIs.
     */
    @JvmName("fmfbltdwoyenvauj")
    public suspend
    fun tpmAttestationAuthentication(`value`: Either<String, TpmAttestationAuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tpmAttestationAuthentication = mapped
    }

    /**
     * @param value The setting that controls whether authentication is enabled or disabled for TPM Attestation REST APIs.
     */
    @JvmName("inqrntnflhscfgjf")
    public fun tpmAttestationAuthentication(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TpmAttestationAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tpmAttestationAuthentication = mapped
    }

    /**
     * @param value The setting that controls whether authentication is enabled or disabled for TPM Attestation REST APIs.
     */
    @JvmName("frpgeylnlqoglnrj")
    public fun tpmAttestationAuthentication(`value`: TpmAttestationAuthenticationType) {
        val toBeMapped = Either.ofRight<String, TpmAttestationAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tpmAttestationAuthentication = mapped
    }

    internal fun build(): AttestationServiceCreationSpecificParamsArgs =
        AttestationServiceCreationSpecificParamsArgs(
            policySigningCertificates = policySigningCertificates,
            publicNetworkAccess = publicNetworkAccess,
            tpmAttestationAuthentication = tpmAttestationAuthentication,
        )
}
