@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.attestation.kotlin.inputs

import com.pulumi.azurenative.attestation.inputs.GetAttestationProviderPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property providerName Name of the attestation provider.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAttestationProviderPlainArgs(
    public val providerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.attestation.inputs.GetAttestationProviderPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.attestation.inputs.GetAttestationProviderPlainArgs =
        com.pulumi.azurenative.attestation.inputs.GetAttestationProviderPlainArgs.builder()
            .providerName(providerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAttestationProviderPlainArgs].
 */
@PulumiTagMarker
public class GetAttestationProviderPlainArgsBuilder internal constructor() {
    private var providerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the attestation provider.
     */
    @JvmName("luxaimmeniguvjcv")
    public suspend fun providerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("forpqjyaotxqtomv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAttestationProviderPlainArgs = GetAttestationProviderPlainArgs(
        providerName = providerName ?: throw PulumiNullFieldException("providerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
