@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.attestation.kotlin.inputs

import com.pulumi.azurenative.attestation.inputs.GetPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
 * @property providerName The name of the attestation provider.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPrivateEndpointConnectionPlainArgs(
    public val privateEndpointConnectionName: String,
    public val providerName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.attestation.inputs.GetPrivateEndpointConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.attestation.inputs.GetPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.attestation.inputs.GetPrivateEndpointConnectionPlainArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .providerName(providerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: String? = null

    private var providerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("wmpktsrquxgmjulg")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The name of the attestation provider.
     */
    @JvmName("nviybrtdkpwhgcdx")
    public suspend fun providerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("njgditfbhegwooyq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionPlainArgs =
        GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            providerName = providerName ?: throw PulumiNullFieldException("providerName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
