@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.ParameterDefinitionsValueResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.authorization.kotlin.outputs.ParameterDefinitionsValueResponse.Companion.toKotlin as parameterDefinitionsValueResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PolicyDefinitionAtManagementGroup].
 */
@PulumiTagMarker
public class PolicyDefinitionAtManagementGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyDefinitionAtManagementGroupArgs = PolicyDefinitionAtManagementGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyDefinitionAtManagementGroupArgsBuilder.() -> Unit) {
        val builder = PolicyDefinitionAtManagementGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PolicyDefinitionAtManagementGroup {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.PolicyDefinitionAtManagementGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PolicyDefinitionAtManagementGroup(builtJavaResource)
    }
}

/**
 * The policy definition.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2018-05-01, 2019-06-01, 2023-04-01.
 * ## Example Usage
 * ### Create or update a policy definition at management group level
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyDefinitionAtManagementGroup = new AzureNative.Authorization.PolicyDefinitionAtManagementGroup("policyDefinitionAtManagementGroup", new()
 *     {
 *         Description = "Force resource names to begin with given 'prefix' and/or end with given 'suffix'",
 *         DisplayName = "Enforce resource naming convention",
 *         ManagementGroupId = "MyManagementGroup",
 *         Metadata =
 *         {
 *             { "category", "Naming" },
 *         },
 *         Mode = "All",
 *         Parameters =
 *         {
 *             { "prefix", new AzureNative.Authorization.Inputs.ParameterDefinitionsValueArgs
 *             {
 *                 Metadata = new AzureNative.Authorization.Inputs.ParameterDefinitionsValueMetadataArgs
 *                 {
 *                     Description = "Resource name prefix",
 *                     DisplayName = "Prefix",
 *                 },
 *                 Type = "String",
 *             } },
 *             { "suffix", new AzureNative.Authorization.Inputs.ParameterDefinitionsValueArgs
 *             {
 *                 Metadata = new AzureNative.Authorization.Inputs.ParameterDefinitionsValueMetadataArgs
 *                 {
 *                     Description = "Resource name suffix",
 *                     DisplayName = "Suffix",
 *                 },
 *                 Type = "String",
 *             } },
 *         },
 *         PolicyDefinitionName = "ResourceNaming",
 *         PolicyRule =
 *         {
 *             { "if",
 *             {
 *                 { "not",
 *                 {
 *                     { "field", "name" },
 *                     { "like", "[concat(parameters('prefix'), '*', parameters('suffix'))]" },
 *                 } },
 *             } },
 *             { "then",
 *             {
 *                 { "effect", "deny" },
 *             } },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyDefinitionAtManagementGroup(ctx, "policyDefinitionAtManagementGroup", &authorization.PolicyDefinitionAtManagementGroupArgs{
 * 			Description:       pulumi.String("Force resource names to begin with given 'prefix' and/or end with given 'suffix'"),
 * 			DisplayName:       pulumi.String("Enforce resource naming convention"),
 * 			ManagementGroupId: pulumi.String("MyManagementGroup"),
 * 			Metadata: pulumi.Any{
 * 				Category: "Naming",
 * 			},
 * 			Mode: pulumi.String("All"),
 * 			Parameters: authorization.ParameterDefinitionsValueMap{
 * 				"prefix": &authorization.ParameterDefinitionsValueArgs{
 * 					Metadata: &authorization.ParameterDefinitionsValueMetadataArgs{
 * 						Description: pulumi.String("Resource name prefix"),
 * 						DisplayName: pulumi.String("Prefix"),
 * 					},
 * 					Type: pulumi.String("String"),
 * 				},
 * 				"suffix": &authorization.ParameterDefinitionsValueArgs{
 * 					Metadata: &authorization.ParameterDefinitionsValueMetadataArgs{
 * 						Description: pulumi.String("Resource name suffix"),
 * 						DisplayName: pulumi.String("Suffix"),
 * 					},
 * 					Type: pulumi.String("String"),
 * 				},
 * 			},
 * 			PolicyDefinitionName: pulumi.String("ResourceNaming"),
 * 			PolicyRule: pulumi.Any{
 * 				If: map[string]interface{}{
 * 					"not": map[string]interface{}{
 * 						"field": "name",
 * 						"like":  "[concat(parameters('prefix'), '*', parameters('suffix'))]",
 * 					},
 * 				},
 * 				Then: map[string]interface{}{
 * 					"effect": "deny",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyDefinitionAtManagementGroup;
 * import com.pulumi.azurenative.authorization.PolicyDefinitionAtManagementGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyDefinitionAtManagementGroup = new PolicyDefinitionAtManagementGroup("policyDefinitionAtManagementGroup", PolicyDefinitionAtManagementGroupArgs.builder()
 *             .description("Force resource names to begin with given 'prefix' and/or end with given 'suffix'")
 *             .displayName("Enforce resource naming convention")
 *             .managementGroupId("MyManagementGroup")
 *             .metadata(Map.of("category", "Naming"))
 *             .mode("All")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("prefix", Map.ofEntries(
 *                     Map.entry("metadata", Map.ofEntries(
 *                         Map.entry("description", "Resource name prefix"),
 *                         Map.entry("displayName", "Prefix")
 *                     )),
 *                     Map.entry("type", "String")
 *                 )),
 *                 Map.entry("suffix", Map.ofEntries(
 *                     Map.entry("metadata", Map.ofEntries(
 *                         Map.entry("description", "Resource name suffix"),
 *                         Map.entry("displayName", "Suffix")
 *                     )),
 *                     Map.entry("type", "String")
 *                 ))
 *             ))
 *             .policyDefinitionName("ResourceNaming")
 *             .policyRule(Map.ofEntries(
 *                 Map.entry("if", Map.of("not", Map.ofEntries(
 *                     Map.entry("field", "name"),
 *                     Map.entry("like", "[concat(parameters('prefix'), '*', parameters('suffix'))]")
 *                 ))),
 *                 Map.entry("then", Map.of("effect", "deny"))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicyDefinitionAtManagementGroup ResourceNaming /providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}
 * ```
 */
public class PolicyDefinitionAtManagementGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.PolicyDefinitionAtManagementGroup,
) : KotlinCustomResource(javaResource, PolicyDefinitionAtManagementGroupMapper) {
    /**
     * The policy definition description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name of the policy definition.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The policy definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
     */
    public val mode: Output<String>?
        get() = javaResource.mode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the policy definition.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
     */
    public val parameters: Output<Map<String, ParameterDefinitionsValueResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            parameterDefinitionsValueResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * The policy rule.
     */
    public val policyRule: Output<Any>?
        get() = javaResource.policyRule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    public val policyType: Output<String>?
        get() = javaResource.policyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource (Microsoft.Authorization/policyDefinitions).
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PolicyDefinitionAtManagementGroupMapper :
    ResourceMapper<PolicyDefinitionAtManagementGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.PolicyDefinitionAtManagementGroup::class == javaResource::class

    override fun map(javaResource: Resource): PolicyDefinitionAtManagementGroup =
        PolicyDefinitionAtManagementGroup(
            javaResource as
                com.pulumi.azurenative.authorization.PolicyDefinitionAtManagementGroup,
        )
}

/**
 * @see [PolicyDefinitionAtManagementGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyDefinitionAtManagementGroup].
 */
public suspend fun policyDefinitionAtManagementGroup(
    name: String,
    block: suspend PolicyDefinitionAtManagementGroupResourceBuilder.() -> Unit,
):
    PolicyDefinitionAtManagementGroup {
    val builder = PolicyDefinitionAtManagementGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyDefinitionAtManagementGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyDefinitionAtManagementGroup(name: String): PolicyDefinitionAtManagementGroup {
    val builder = PolicyDefinitionAtManagementGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
