@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.ParameterDefinitionsValueResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.authorization.kotlin.outputs.ParameterDefinitionsValueResponse.Companion.toKotlin as parameterDefinitionsValueResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PolicyDefinitionVersion].
 */
@PulumiTagMarker
public class PolicyDefinitionVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyDefinitionVersionArgs = PolicyDefinitionVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyDefinitionVersionArgsBuilder.() -> Unit) {
        val builder = PolicyDefinitionVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PolicyDefinitionVersion {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.PolicyDefinitionVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PolicyDefinitionVersion(builtJavaResource)
    }
}

/**
 * The ID of the policy definition version.
 * Azure REST API version: 2023-04-01.
 * ## Example Usage
 * ### Create or update a policy definition version
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyDefinitionVersion = new AzureNative.Authorization.PolicyDefinitionVersion("policyDefinitionVersion", new()
 *     {
 *         Description = "Force resource names to begin with given 'prefix' and/or end with given 'suffix'",
 *         DisplayName = "Enforce resource naming convention",
 *         Metadata =
 *         {
 *             { "category", "Naming" },
 *         },
 *         Mode = "All",
 *         Parameters =
 *         {
 *             { "prefix", new AzureNative.Authorization.Inputs.ParameterDefinitionsValueArgs
 *             {
 *                 Metadata = new AzureNative.Authorization.Inputs.ParameterDefinitionsValueMetadataArgs
 *                 {
 *                     Description = "Resource name prefix",
 *                     DisplayName = "Prefix",
 *                 },
 *                 Type = "String",
 *             } },
 *             { "suffix", new AzureNative.Authorization.Inputs.ParameterDefinitionsValueArgs
 *             {
 *                 Metadata = new AzureNative.Authorization.Inputs.ParameterDefinitionsValueMetadataArgs
 *                 {
 *                     Description = "Resource name suffix",
 *                     DisplayName = "Suffix",
 *                 },
 *                 Type = "String",
 *             } },
 *         },
 *         PolicyDefinitionName = "ResourceNaming",
 *         PolicyDefinitionVersion = "1.2.1",
 *         PolicyRule =
 *         {
 *             { "if",
 *             {
 *                 { "not",
 *                 {
 *                     { "field", "name" },
 *                     { "like", "[concat(parameters('prefix'), '*', parameters('suffix'))]" },
 *                 } },
 *             } },
 *             { "then",
 *             {
 *                 { "effect", "deny" },
 *             } },
 *         },
 *         Version = "1.2.1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyDefinitionVersion(ctx, "policyDefinitionVersion", &authorization.PolicyDefinitionVersionArgs{
 * 			Description: pulumi.String("Force resource names to begin with given 'prefix' and/or end with given 'suffix'"),
 * 			DisplayName: pulumi.String("Enforce resource naming convention"),
 * 			Metadata: pulumi.Any{
 * 				Category: "Naming",
 * 			},
 * 			Mode: pulumi.String("All"),
 * 			Parameters: authorization.ParameterDefinitionsValueMap{
 * 				"prefix": &authorization.ParameterDefinitionsValueArgs{
 * 					Metadata: &authorization.ParameterDefinitionsValueMetadataArgs{
 * 						Description: pulumi.String("Resource name prefix"),
 * 						DisplayName: pulumi.String("Prefix"),
 * 					},
 * 					Type: pulumi.String("String"),
 * 				},
 * 				"suffix": &authorization.ParameterDefinitionsValueArgs{
 * 					Metadata: &authorization.ParameterDefinitionsValueMetadataArgs{
 * 						Description: pulumi.String("Resource name suffix"),
 * 						DisplayName: pulumi.String("Suffix"),
 * 					},
 * 					Type: pulumi.String("String"),
 * 				},
 * 			},
 * 			PolicyDefinitionName:    pulumi.String("ResourceNaming"),
 * 			PolicyDefinitionVersion: pulumi.String("1.2.1"),
 * 			PolicyRule: pulumi.Any{
 * 				If: map[string]interface{}{
 * 					"not": map[string]interface{}{
 * 						"field": "name",
 * 						"like":  "[concat(parameters('prefix'), '*', parameters('suffix'))]",
 * 					},
 * 				},
 * 				Then: map[string]interface{}{
 * 					"effect": "deny",
 * 				},
 * 			},
 * 			Version: pulumi.String("1.2.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyDefinitionVersion;
 * import com.pulumi.azurenative.authorization.PolicyDefinitionVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyDefinitionVersion = new PolicyDefinitionVersion("policyDefinitionVersion", PolicyDefinitionVersionArgs.builder()
 *             .description("Force resource names to begin with given 'prefix' and/or end with given 'suffix'")
 *             .displayName("Enforce resource naming convention")
 *             .metadata(Map.of("category", "Naming"))
 *             .mode("All")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("prefix", Map.ofEntries(
 *                     Map.entry("metadata", Map.ofEntries(
 *                         Map.entry("description", "Resource name prefix"),
 *                         Map.entry("displayName", "Prefix")
 *                     )),
 *                     Map.entry("type", "String")
 *                 )),
 *                 Map.entry("suffix", Map.ofEntries(
 *                     Map.entry("metadata", Map.ofEntries(
 *                         Map.entry("description", "Resource name suffix"),
 *                         Map.entry("displayName", "Suffix")
 *                     )),
 *                     Map.entry("type", "String")
 *                 ))
 *             ))
 *             .policyDefinitionName("ResourceNaming")
 *             .policyDefinitionVersion("1.2.1")
 *             .policyRule(Map.ofEntries(
 *                 Map.entry("if", Map.of("not", Map.ofEntries(
 *                     Map.entry("field", "name"),
 *                     Map.entry("like", "[concat(parameters('prefix'), '*', parameters('suffix'))]")
 *                 ))),
 *                 Map.entry("then", Map.of("effect", "deny"))
 *             ))
 *             .version("1.2.1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicyDefinitionVersion 1.2.1 /subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}/versions/{policyDefinitionVersion}
 * ```
 */
public class PolicyDefinitionVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.PolicyDefinitionVersion,
) : KotlinCustomResource(javaResource, PolicyDefinitionVersionMapper) {
    /**
     * The policy definition description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name of the policy definition.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The policy definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
     */
    public val mode: Output<String>?
        get() = javaResource.mode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the policy definition version.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
     */
    public val parameters: Output<Map<String, ParameterDefinitionsValueResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            parameterDefinitionsValueResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * The policy rule.
     */
    public val policyRule: Output<Any>?
        get() = javaResource.policyRule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    public val policyType: Output<String>?
        get() = javaResource.policyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource (Microsoft.Authorization/policyDefinitions/versions).
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The policy definition version in #.#.# format.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object PolicyDefinitionVersionMapper : ResourceMapper<PolicyDefinitionVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.PolicyDefinitionVersion::class == javaResource::class

    override fun map(javaResource: Resource): PolicyDefinitionVersion =
        PolicyDefinitionVersion(
            javaResource as
                com.pulumi.azurenative.authorization.PolicyDefinitionVersion,
        )
}

/**
 * @see [PolicyDefinitionVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyDefinitionVersion].
 */
public suspend fun policyDefinitionVersion(
    name: String,
    block: suspend PolicyDefinitionVersionResourceBuilder.() -> Unit,
): PolicyDefinitionVersion {
    val builder = PolicyDefinitionVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyDefinitionVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyDefinitionVersion(name: String): PolicyDefinitionVersion {
    val builder = PolicyDefinitionVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
