@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.ParameterDefinitionsValueResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyDefinitionGroupResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyDefinitionReferenceResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.authorization.kotlin.outputs.ParameterDefinitionsValueResponse.Companion.toKotlin as parameterDefinitionsValueResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyDefinitionGroupResponse.Companion.toKotlin as policyDefinitionGroupResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyDefinitionReferenceResponse.Companion.toKotlin as policyDefinitionReferenceResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PolicySetDefinitionVersion].
 */
@PulumiTagMarker
public class PolicySetDefinitionVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicySetDefinitionVersionArgs = PolicySetDefinitionVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicySetDefinitionVersionArgsBuilder.() -> Unit) {
        val builder = PolicySetDefinitionVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PolicySetDefinitionVersion {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.PolicySetDefinitionVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PolicySetDefinitionVersion(builtJavaResource)
    }
}

/**
 * The policy set definition version.
 * Azure REST API version: 2023-04-01.
 * ## Example Usage
 * ### Create or update a policy set definition version
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policySetDefinitionVersion = new AzureNative.Authorization.PolicySetDefinitionVersion("policySetDefinitionVersion", new()
 *     {
 *         Description = "Policies to enforce low cost storage SKUs",
 *         DisplayName = "Cost Management",
 *         Metadata =
 *         {
 *             { "category", "Cost Management" },
 *         },
 *         Parameters =
 *         {
 *             { "namePrefix", new AzureNative.Authorization.Inputs.ParameterDefinitionsValueArgs
 *             {
 *                 DefaultValue = "myPrefix",
 *                 Metadata = new AzureNative.Authorization.Inputs.ParameterDefinitionsValueMetadataArgs
 *                 {
 *                     DisplayName = "Prefix to enforce on resource names",
 *                 },
 *                 Type = "String",
 *             } },
 *         },
 *         PolicyDefinitionVersion = "1.2.1",
 *         PolicyDefinitions = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "listOfAllowedSKUs", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = new[]
 *                         {
 *                             "Standard_GRS",
 *                             "Standard_LRS",
 *                         },
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1",
 *                 PolicyDefinitionReferenceId = "Limit_Skus",
 *             },
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "[parameters('namePrefix')]",
 *                     } },
 *                     { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "-LC",
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *                 PolicyDefinitionReferenceId = "Resource_Naming",
 *             },
 *         },
 *         PolicySetDefinitionName = "CostManagement",
 *         Version = "1.2.1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicySetDefinitionVersion(ctx, "policySetDefinitionVersion", &authorization.PolicySetDefinitionVersionArgs{
 * 			Description: pulumi.String("Policies to enforce low cost storage SKUs"),
 * 			DisplayName: pulumi.String("Cost Management"),
 * 			Metadata: pulumi.Any{
 * 				Category: "Cost Management",
 * 			},
 * 			Parameters: authorization.ParameterDefinitionsValueMap{
 * 				"namePrefix": &authorization.ParameterDefinitionsValueArgs{
 * 					DefaultValue: pulumi.Any("myPrefix"),
 * 					Metadata: &authorization.ParameterDefinitionsValueMetadataArgs{
 * 						DisplayName: pulumi.String("Prefix to enforce on resource names"),
 * 					},
 * 					Type: pulumi.String("String"),
 * 				},
 * 			},
 * 			PolicyDefinitionVersion: pulumi.String("1.2.1"),
 * 			PolicyDefinitions: []authorization.PolicyDefinitionReferenceArgs{
 * 				{
 * 					Parameters: {
 * 						"listOfAllowedSKUs": {
 * 							Value: pulumi.Any{
 * 								"Standard_GRS",
 * 								"Standard_LRS",
 * 							},
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Limit_Skus"),
 * 				},
 * 				{
 * 					Parameters: {
 * 						"prefix": {
 * 							Value: pulumi.Any("[parameters('namePrefix')]"),
 * 						},
 * 						"suffix": {
 * 							Value: pulumi.Any("-LC"),
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Resource_Naming"),
 * 				},
 * 			},
 * 			PolicySetDefinitionName: pulumi.String("CostManagement"),
 * 			Version:                 pulumi.String("1.2.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionVersion;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policySetDefinitionVersion = new PolicySetDefinitionVersion("policySetDefinitionVersion", PolicySetDefinitionVersionArgs.builder()
 *             .description("Policies to enforce low cost storage SKUs")
 *             .displayName("Cost Management")
 *             .metadata(Map.of("category", "Cost Management"))
 *             .parameters(Map.of("namePrefix", Map.ofEntries(
 *                 Map.entry("defaultValue", "myPrefix"),
 *                 Map.entry("metadata", Map.of("displayName", "Prefix to enforce on resource names")),
 *                 Map.entry("type", "String")
 *             )))
 *             .policyDefinitionVersion("1.2.1")
 *             .policyDefinitions(
 *                 Map.ofEntries(
 *                     Map.entry("parameters", Map.of("listOfAllowedSKUs", Map.of("value",
 *                         "Standard_GRS",
 *                         "Standard_LRS"))),
 *                     Map.entry("policyDefinitionId", "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 *                     Map.entry("policyDefinitionReferenceId", "Limit_Skus")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("parameters", Map.ofEntries(
 *                         Map.entry("prefix", Map.of("value", "[parameters('namePrefix')]")),
 *                         Map.entry("suffix", Map.of("value", "-LC"))
 *                     )),
 *                     Map.entry("policyDefinitionId", "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 *                     Map.entry("policyDefinitionReferenceId", "Resource_Naming")
 *                 ))
 *             .policySetDefinitionName("CostManagement")
 *             .version("1.2.1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicySetDefinitionVersion 1.2.1 /subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}/versions/{policyDefinitionVersion}
 * ```
 */
public class PolicySetDefinitionVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.PolicySetDefinitionVersion,
) : KotlinCustomResource(javaResource, PolicySetDefinitionVersionMapper) {
    /**
     * The policy set definition description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name of the policy set definition.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the policy set definition version.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The policy set definition parameters that can be used in policy definition references.
     */
    public val parameters: Output<Map<String, ParameterDefinitionsValueResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            parameterDefinitionsValueResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * The metadata describing groups of policy definition references within the policy set definition.
     */
    public val policyDefinitionGroups: Output<List<PolicyDefinitionGroupResponse>>?
        get() = javaResource.policyDefinitionGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        policyDefinitionGroupResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * An array of policy definition references.
     */
    public val policyDefinitions: Output<List<PolicyDefinitionReferenceResponse>>
        get() = javaResource.policyDefinitions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> policyDefinitionReferenceResponseToKotlin(args0) })
            })
        })

    /**
     * The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    public val policyType: Output<String>?
        get() = javaResource.policyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource (Microsoft.Authorization/policySetDefinitions/versions).
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The policy set definition version in #.#.# format.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object PolicySetDefinitionVersionMapper : ResourceMapper<PolicySetDefinitionVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.PolicySetDefinitionVersion::class == javaResource::class

    override fun map(javaResource: Resource): PolicySetDefinitionVersion =
        PolicySetDefinitionVersion(
            javaResource as
                com.pulumi.azurenative.authorization.PolicySetDefinitionVersion,
        )
}

/**
 * @see [PolicySetDefinitionVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicySetDefinitionVersion].
 */
public suspend fun policySetDefinitionVersion(
    name: String,
    block: suspend PolicySetDefinitionVersionResourceBuilder.() -> Unit,
):
    PolicySetDefinitionVersion {
    val builder = PolicySetDefinitionVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicySetDefinitionVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policySetDefinitionVersion(name: String): PolicySetDefinitionVersion {
    val builder = PolicySetDefinitionVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
