@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.PrivateLinkAssociationArgs.builder
import com.pulumi.azurenative.authorization.kotlin.inputs.PrivateLinkAssociationPropertiesArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.PrivateLinkAssociationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2020-05-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create a private link association, associate scope to rmpl.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkAssociation = new AzureNative.Authorization.PrivateLinkAssociation("privateLinkAssociation", new()
 *     {
 *         GroupId = "my-management-group",
 *         PlaId = "00000000-0000-0000-0000-000000000000",
 *         Properties = new AzureNative.Authorization.Inputs.PrivateLinkAssociationPropertiesArgs
 *         {
 *             PrivateLink = "00000000-0000-0000-0000-000000000000",
 *             PublicNetworkAccess = "Enabled",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPrivateLinkAssociation(ctx, "privateLinkAssociation", &authorization.PrivateLinkAssociationArgs{
 * 			GroupId: pulumi.String("my-management-group"),
 * 			PlaId:   pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 			Properties: &authorization.PrivateLinkAssociationPropertiesArgs{
 * 				PrivateLink:         pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 				PublicNetworkAccess: pulumi.String("Enabled"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PrivateLinkAssociation;
 * import com.pulumi.azurenative.authorization.PrivateLinkAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkAssociation = new PrivateLinkAssociation("privateLinkAssociation", PrivateLinkAssociationArgs.builder()
 *             .groupId("my-management-group")
 *             .plaId("00000000-0000-0000-0000-000000000000")
 *             .properties(Map.ofEntries(
 *                 Map.entry("privateLink", "00000000-0000-0000-0000-000000000000"),
 *                 Map.entry("publicNetworkAccess", "Enabled")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PrivateLinkAssociation my-pla /providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Authorization/privateLinkAssociations/{plaId}
 * ```
 * @property groupId The management group ID.
 * @property plaId The ID of the PLA
 * @property properties The properties of the PrivateLinkAssociation.
 */
public data class PrivateLinkAssociationArgs(
    public val groupId: Output<String>? = null,
    public val plaId: Output<String>? = null,
    public val properties: Output<PrivateLinkAssociationPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.PrivateLinkAssociationArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.PrivateLinkAssociationArgs =
        com.pulumi.azurenative.authorization.PrivateLinkAssociationArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .plaId(plaId?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PrivateLinkAssociationArgs].
 */
@PulumiTagMarker
public class PrivateLinkAssociationArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var plaId: Output<String>? = null

    private var properties: Output<PrivateLinkAssociationPropertiesArgs>? = null

    /**
     * @param value The management group ID.
     */
    @JvmName("jwcnmbtrhxiklekv")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The ID of the PLA
     */
    @JvmName("ewewiaxcfnxinhfd")
    public suspend fun plaId(`value`: Output<String>) {
        this.plaId = value
    }

    /**
     * @param value The properties of the PrivateLinkAssociation.
     */
    @JvmName("jygqnrtfjafhhwdq")
    public suspend fun properties(`value`: Output<PrivateLinkAssociationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The management group ID.
     */
    @JvmName("wjuphyhuuevxceqs")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The ID of the PLA
     */
    @JvmName("hnrxvyxhbdyrkubk")
    public suspend fun plaId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plaId = mapped
    }

    /**
     * @param value The properties of the PrivateLinkAssociation.
     */
    @JvmName("oftohsxqtqelnare")
    public suspend fun properties(`value`: PrivateLinkAssociationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The properties of the PrivateLinkAssociation.
     */
    @JvmName("haqswahvjasqtprt")
    public suspend
    fun properties(argument: suspend PrivateLinkAssociationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkAssociationPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): PrivateLinkAssociationArgs = PrivateLinkAssociationArgs(
        groupId = groupId,
        plaId = plaId,
        properties = properties,
    )
}
