@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.VariableValueArgs.builder
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyVariableValueColumnValueArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyVariableValueColumnValueArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The variable value.
 * Azure REST API version: 2022-08-01-preview.
 * ## Example Usage
 * ### Create or update a variable value
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var variableValue = new AzureNative.Authorization.VariableValue("variableValue", new()
 *     {
 *         Values = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyVariableValueColumnValueArgs
 *             {
 *                 ColumnName = "StringColumn",
 *                 ColumnValue = "SampleValue",
 *             },
 *             new AzureNative.Authorization.Inputs.PolicyVariableValueColumnValueArgs
 *             {
 *                 ColumnName = "IntegerColumn",
 *                 ColumnValue = 10,
 *             },
 *         },
 *         VariableName = "DemoTestVariable",
 *         VariableValueName = "TestValue",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewVariableValue(ctx, "variableValue", &authorization.VariableValueArgs{
 * 			Values: []authorization.PolicyVariableValueColumnValueArgs{
 * 				{
 * 					ColumnName:  pulumi.String("StringColumn"),
 * 					ColumnValue: pulumi.Any("SampleValue"),
 * 				},
 * 				{
 * 					ColumnName:  pulumi.String("IntegerColumn"),
 * 					ColumnValue: pulumi.Any(10),
 * 				},
 * 			},
 * 			VariableName:      pulumi.String("DemoTestVariable"),
 * 			VariableValueName: pulumi.String("TestValue"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.VariableValue;
 * import com.pulumi.azurenative.authorization.VariableValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var variableValue = new VariableValue("variableValue", VariableValueArgs.builder()
 *             .values(
 *                 Map.ofEntries(
 *                     Map.entry("columnName", "StringColumn"),
 *                     Map.entry("columnValue", "SampleValue")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("columnName", "IntegerColumn"),
 *                     Map.entry("columnValue", 10)
 *                 ))
 *             .variableName("DemoTestVariable")
 *             .variableValueName("TestValue")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:VariableValue TestValue /subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}/values/{variableValueName}
 * ```
 * @property values Variable value column value array.
 * @property variableName The name of the variable to operate on.
 * @property variableValueName The name of the variable value to operate on.
 */
public data class VariableValueArgs(
    public val values: Output<List<PolicyVariableValueColumnValueArgs>>? = null,
    public val variableName: Output<String>? = null,
    public val variableValueName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.VariableValueArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.VariableValueArgs =
        com.pulumi.azurenative.authorization.VariableValueArgs.builder()
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .variableName(variableName?.applyValue({ args0 -> args0 }))
            .variableValueName(variableValueName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VariableValueArgs].
 */
@PulumiTagMarker
public class VariableValueArgsBuilder internal constructor() {
    private var values: Output<List<PolicyVariableValueColumnValueArgs>>? = null

    private var variableName: Output<String>? = null

    private var variableValueName: Output<String>? = null

    /**
     * @param value Variable value column value array.
     */
    @JvmName("kqfbkhdemmprjlfd")
    public suspend fun values(`value`: Output<List<PolicyVariableValueColumnValueArgs>>) {
        this.values = value
    }

    @JvmName("abuhsjvwhbhcmbse")
    public suspend fun values(vararg values: Output<PolicyVariableValueColumnValueArgs>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Variable value column value array.
     */
    @JvmName("uxksypvldqgxsavn")
    public suspend fun values(values: List<Output<PolicyVariableValueColumnValueArgs>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The name of the variable to operate on.
     */
    @JvmName("kbnexnwsouqjbaxc")
    public suspend fun variableName(`value`: Output<String>) {
        this.variableName = value
    }

    /**
     * @param value The name of the variable value to operate on.
     */
    @JvmName("ubcqlvfxtwqlhqtc")
    public suspend fun variableValueName(`value`: Output<String>) {
        this.variableValueName = value
    }

    /**
     * @param value Variable value column value array.
     */
    @JvmName("ggliafiqtnhkmmey")
    public suspend fun values(`value`: List<PolicyVariableValueColumnValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param argument Variable value column value array.
     */
    @JvmName("kqfmldrvivfogyup")
    public suspend
    fun values(argument: List<suspend PolicyVariableValueColumnValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyVariableValueColumnValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument Variable value column value array.
     */
    @JvmName("vomhqiavlsvjibnd")
    public suspend fun values(
        vararg
        argument: suspend PolicyVariableValueColumnValueArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PolicyVariableValueColumnValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument Variable value column value array.
     */
    @JvmName("bimlafowgrgsejka")
    public suspend
    fun values(argument: suspend PolicyVariableValueColumnValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PolicyVariableValueColumnValueArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param values Variable value column value array.
     */
    @JvmName("sifjhltfdvmvnjnx")
    public suspend fun values(vararg values: PolicyVariableValueColumnValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param value The name of the variable to operate on.
     */
    @JvmName("qriffaelqebakexl")
    public suspend fun variableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variableName = mapped
    }

    /**
     * @param value The name of the variable value to operate on.
     */
    @JvmName("dynvygswrbmtkwog")
    public suspend fun variableValueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variableValueName = mapped
    }

    internal fun build(): VariableValueArgs = VariableValueArgs(
        values = values,
        variableName = variableName,
        variableValueName = variableValueName,
    )
}
