@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyVariableValueColumnValueResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyVariableValueColumnValueResponse.Companion.toKotlin as policyVariableValueColumnValueResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [VariableValueAtManagementGroup].
 */
@PulumiTagMarker
public class VariableValueAtManagementGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VariableValueAtManagementGroupArgs = VariableValueAtManagementGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VariableValueAtManagementGroupArgsBuilder.() -> Unit) {
        val builder = VariableValueAtManagementGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VariableValueAtManagementGroup {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.VariableValueAtManagementGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VariableValueAtManagementGroup(builtJavaResource)
    }
}

/**
 * The variable value.
 * Azure REST API version: 2022-08-01-preview.
 * ## Example Usage
 * ### Create or update a variable value at management group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var variableValueAtManagementGroup = new AzureNative.Authorization.VariableValueAtManagementGroup("variableValueAtManagementGroup", new()
 *     {
 *         ManagementGroupId = "DevOrg",
 *         Values = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyVariableValueColumnValueArgs
 *             {
 *                 ColumnName = "StringColumn",
 *                 ColumnValue = "SampleValue",
 *             },
 *             new AzureNative.Authorization.Inputs.PolicyVariableValueColumnValueArgs
 *             {
 *                 ColumnName = "IntegerColumn",
 *                 ColumnValue = 10,
 *             },
 *         },
 *         VariableName = "DemoTestVariable",
 *         VariableValueName = "TestValue",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewVariableValueAtManagementGroup(ctx, "variableValueAtManagementGroup", &authorization.VariableValueAtManagementGroupArgs{
 * 			ManagementGroupId: pulumi.String("DevOrg"),
 * 			Values: []authorization.PolicyVariableValueColumnValueArgs{
 * 				{
 * 					ColumnName:  pulumi.String("StringColumn"),
 * 					ColumnValue: pulumi.Any("SampleValue"),
 * 				},
 * 				{
 * 					ColumnName:  pulumi.String("IntegerColumn"),
 * 					ColumnValue: pulumi.Any(10),
 * 				},
 * 			},
 * 			VariableName:      pulumi.String("DemoTestVariable"),
 * 			VariableValueName: pulumi.String("TestValue"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.VariableValueAtManagementGroup;
 * import com.pulumi.azurenative.authorization.VariableValueAtManagementGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var variableValueAtManagementGroup = new VariableValueAtManagementGroup("variableValueAtManagementGroup", VariableValueAtManagementGroupArgs.builder()
 *             .managementGroupId("DevOrg")
 *             .values(
 *                 Map.ofEntries(
 *                     Map.entry("columnName", "StringColumn"),
 *                     Map.entry("columnValue", "SampleValue")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("columnName", "IntegerColumn"),
 *                     Map.entry("columnValue", 10)
 *                 ))
 *             .variableName("DemoTestVariable")
 *             .variableValueName("TestValue")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:VariableValueAtManagementGroup TestValue /providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}/values/{variableValueName}
 * ```
 */
public class VariableValueAtManagementGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.VariableValueAtManagementGroup,
) : KotlinCustomResource(javaResource, VariableValueAtManagementGroupMapper) {
    /**
     * The name of the variable.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource (Microsoft.Authorization/variables/values).
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Variable value column value array.
     */
    public val values: Output<List<PolicyVariableValueColumnValueResponse>>
        get() = javaResource.values().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    policyVariableValueColumnValueResponseToKotlin(args0)
                })
            })
        })
}

public object VariableValueAtManagementGroupMapper : ResourceMapper<VariableValueAtManagementGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.VariableValueAtManagementGroup::class == javaResource::class

    override fun map(javaResource: Resource): VariableValueAtManagementGroup =
        VariableValueAtManagementGroup(
            javaResource as
                com.pulumi.azurenative.authorization.VariableValueAtManagementGroup,
        )
}

/**
 * @see [VariableValueAtManagementGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VariableValueAtManagementGroup].
 */
public suspend fun variableValueAtManagementGroup(
    name: String,
    block: suspend VariableValueAtManagementGroupResourceBuilder.() -> Unit,
):
    VariableValueAtManagementGroup {
    val builder = VariableValueAtManagementGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VariableValueAtManagementGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun variableValueAtManagementGroup(name: String): VariableValueAtManagementGroup {
    val builder = VariableValueAtManagementGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
