@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The policy assignment enforcement mode. Possible values are Default and DoNotEnforce.
 */
public enum class EnforcementMode(
    public val javaValue: com.pulumi.azurenative.authorization.enums.EnforcementMode,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.enums.EnforcementMode> {
    /**
     * The policy effect is enforced during resource creation or update.
     */
    Default(com.pulumi.azurenative.authorization.enums.EnforcementMode.Default),

    /**
     * The policy effect is not enforced during resource creation or update.
     */
    DoNotEnforce(com.pulumi.azurenative.authorization.enums.EnforcementMode.DoNotEnforce),
    ;

    override fun toJava(): com.pulumi.azurenative.authorization.enums.EnforcementMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.enums.EnforcementMode):
            EnforcementMode = EnforcementMode.values().first { it.javaValue == javaType }
    }
}
