@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a resource, but they can't modify or delete it.
 */
public enum class LockLevel(
    public val javaValue: com.pulumi.azurenative.authorization.enums.LockLevel,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.enums.LockLevel> {
    NotSpecified(com.pulumi.azurenative.authorization.enums.LockLevel.NotSpecified),
    CanNotDelete(com.pulumi.azurenative.authorization.enums.LockLevel.CanNotDelete),
    ReadOnly(com.pulumi.azurenative.authorization.enums.LockLevel.ReadOnly),
    ;

    override fun toJava(): com.pulumi.azurenative.authorization.enums.LockLevel = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.enums.LockLevel): LockLevel =
            LockLevel.values().first { it.javaValue == javaType }
    }
}
