@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The selector kind.
 */
public enum class SelectorKind(
    public val javaValue: com.pulumi.azurenative.authorization.enums.SelectorKind,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.enums.SelectorKind> {
    /**
     * The selector kind to filter policies by the resource location.
     */
    ResourceLocation(com.pulumi.azurenative.authorization.enums.SelectorKind.ResourceLocation),

    /**
     * The selector kind to filter policies by the resource type.
     */
    ResourceType(com.pulumi.azurenative.authorization.enums.SelectorKind.ResourceType),

    /**
     * The selector kind to filter policies by the resource without location.
     */
    ResourceWithoutLocation(com.pulumi.azurenative.authorization.enums.SelectorKind.ResourceWithoutLocation),

    /**
     * The selector kind to filter policies by the policy definition reference ID.
     */
    PolicyDefinitionReferenceId(com.pulumi.azurenative.authorization.enums.SelectorKind.PolicyDefinitionReferenceId),
    ;

    override fun toJava(): com.pulumi.azurenative.authorization.enums.SelectorKind = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.enums.SelectorKind):
            SelectorKind = SelectorKind.values().first { it.javaValue == javaType }
    }
}
