@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.AccessReviewInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Access Review Instance.
 * @property backupReviewers This is the collection of backup reviewers.
 * @property endDateTime The DateTime when the review instance is scheduled to end.
 * @property reviewers This is the collection of reviewers.
 * @property startDateTime The DateTime when the review instance is scheduled to be start.
 */
public data class AccessReviewInstanceArgs(
    public val backupReviewers: Output<List<AccessReviewReviewerArgs>>? = null,
    public val endDateTime: Output<String>? = null,
    public val reviewers: Output<List<AccessReviewReviewerArgs>>? = null,
    public val startDateTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.AccessReviewInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.AccessReviewInstanceArgs =
        com.pulumi.azurenative.authorization.inputs.AccessReviewInstanceArgs.builder()
            .backupReviewers(
                backupReviewers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .endDateTime(endDateTime?.applyValue({ args0 -> args0 }))
            .reviewers(
                reviewers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .startDateTime(startDateTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessReviewInstanceArgs].
 */
@PulumiTagMarker
public class AccessReviewInstanceArgsBuilder internal constructor() {
    private var backupReviewers: Output<List<AccessReviewReviewerArgs>>? = null

    private var endDateTime: Output<String>? = null

    private var reviewers: Output<List<AccessReviewReviewerArgs>>? = null

    private var startDateTime: Output<String>? = null

    /**
     * @param value This is the collection of backup reviewers.
     */
    @JvmName("ycwtqalruclbrelh")
    public suspend fun backupReviewers(`value`: Output<List<AccessReviewReviewerArgs>>) {
        this.backupReviewers = value
    }

    @JvmName("rejvalleystjmnkh")
    public suspend fun backupReviewers(vararg values: Output<AccessReviewReviewerArgs>) {
        this.backupReviewers = Output.all(values.asList())
    }

    /**
     * @param values This is the collection of backup reviewers.
     */
    @JvmName("oyombeqvyxitvjao")
    public suspend fun backupReviewers(values: List<Output<AccessReviewReviewerArgs>>) {
        this.backupReviewers = Output.all(values)
    }

    /**
     * @param value The DateTime when the review instance is scheduled to end.
     */
    @JvmName("qyolxgtjlmtckuki")
    public suspend fun endDateTime(`value`: Output<String>) {
        this.endDateTime = value
    }

    /**
     * @param value This is the collection of reviewers.
     */
    @JvmName("jeogxfjppjnawttq")
    public suspend fun reviewers(`value`: Output<List<AccessReviewReviewerArgs>>) {
        this.reviewers = value
    }

    @JvmName("ecncphiolhxogkkc")
    public suspend fun reviewers(vararg values: Output<AccessReviewReviewerArgs>) {
        this.reviewers = Output.all(values.asList())
    }

    /**
     * @param values This is the collection of reviewers.
     */
    @JvmName("dishwsyrwuyjkshi")
    public suspend fun reviewers(values: List<Output<AccessReviewReviewerArgs>>) {
        this.reviewers = Output.all(values)
    }

    /**
     * @param value The DateTime when the review instance is scheduled to be start.
     */
    @JvmName("hbhtywoxyjilacxf")
    public suspend fun startDateTime(`value`: Output<String>) {
        this.startDateTime = value
    }

    /**
     * @param value This is the collection of backup reviewers.
     */
    @JvmName("mikcvoasaqmeneep")
    public suspend fun backupReviewers(`value`: List<AccessReviewReviewerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupReviewers = mapped
    }

    /**
     * @param argument This is the collection of backup reviewers.
     */
    @JvmName("qvqjgyaradaybwtp")
    public suspend
    fun backupReviewers(argument: List<suspend AccessReviewReviewerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessReviewReviewerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.backupReviewers = mapped
    }

    /**
     * @param argument This is the collection of backup reviewers.
     */
    @JvmName("njvaurfnnkdwgset")
    public suspend fun backupReviewers(
        vararg
        argument: suspend AccessReviewReviewerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AccessReviewReviewerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.backupReviewers = mapped
    }

    /**
     * @param argument This is the collection of backup reviewers.
     */
    @JvmName("mgkmbknmunoyaeam")
    public suspend fun backupReviewers(argument: suspend AccessReviewReviewerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AccessReviewReviewerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.backupReviewers = mapped
    }

    /**
     * @param values This is the collection of backup reviewers.
     */
    @JvmName("rfnsowtidgqbesph")
    public suspend fun backupReviewers(vararg values: AccessReviewReviewerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupReviewers = mapped
    }

    /**
     * @param value The DateTime when the review instance is scheduled to end.
     */
    @JvmName("tgfpscnhrefghphy")
    public suspend fun endDateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDateTime = mapped
    }

    /**
     * @param value This is the collection of reviewers.
     */
    @JvmName("ufyvkurujpbgqeyg")
    public suspend fun reviewers(`value`: List<AccessReviewReviewerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reviewers = mapped
    }

    /**
     * @param argument This is the collection of reviewers.
     */
    @JvmName("ktuxeyvurlxpylxk")
    public suspend fun reviewers(argument: List<suspend AccessReviewReviewerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessReviewReviewerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.reviewers = mapped
    }

    /**
     * @param argument This is the collection of reviewers.
     */
    @JvmName("jgowtadxwdsedajh")
    public suspend fun reviewers(
        vararg
        argument: suspend AccessReviewReviewerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AccessReviewReviewerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.reviewers = mapped
    }

    /**
     * @param argument This is the collection of reviewers.
     */
    @JvmName("xmvpjmgluqxhbyjc")
    public suspend fun reviewers(argument: suspend AccessReviewReviewerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AccessReviewReviewerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.reviewers = mapped
    }

    /**
     * @param values This is the collection of reviewers.
     */
    @JvmName("tmxcomcetkwmqkyj")
    public suspend fun reviewers(vararg values: AccessReviewReviewerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reviewers = mapped
    }

    /**
     * @param value The DateTime when the review instance is scheduled to be start.
     */
    @JvmName("qnxvkfslmbicoyvy")
    public suspend fun startDateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startDateTime = mapped
    }

    internal fun build(): AccessReviewInstanceArgs = AccessReviewInstanceArgs(
        backupReviewers = backupReviewers,
        endDateTime = endDateTime,
        reviewers = reviewers,
        startDateTime = startDateTime,
    )
}
