@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetClientTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpoint Optional authentication endpoint. Defaults to the endpoint of Azure Resource Manager.
 */
public data class GetClientTokenPlainArgs(
    public val endpoint: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetClientTokenPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.GetClientTokenPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetClientTokenPlainArgs.builder()
            .endpoint(endpoint?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClientTokenPlainArgs].
 */
@PulumiTagMarker
public class GetClientTokenPlainArgsBuilder internal constructor() {
    private var endpoint: String? = null

    /**
     * @param value Optional authentication endpoint. Defaults to the endpoint of Azure Resource Manager.
     */
    @JvmName("ffcecsiktlkbbkij")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpoint = mapped
    }

    internal fun build(): GetClientTokenPlainArgs = GetClientTokenPlainArgs(
        endpoint = endpoint,
    )
}
