@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetManagementLockAtResourceGroupLevelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lockName The name of the lock to get.
 * @property resourceGroupName The name of the locked resource group.
 */
public data class GetManagementLockAtResourceGroupLevelPlainArgs(
    public val lockName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetManagementLockAtResourceGroupLevelPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.GetManagementLockAtResourceGroupLevelPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetManagementLockAtResourceGroupLevelPlainArgs.builder()
            .lockName(lockName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagementLockAtResourceGroupLevelPlainArgs].
 */
@PulumiTagMarker
public class GetManagementLockAtResourceGroupLevelPlainArgsBuilder internal constructor() {
    private var lockName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the lock to get.
     */
    @JvmName("vwjnnmunowbnyhco")
    public suspend fun lockName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.lockName = mapped
    }

    /**
     * @param value The name of the locked resource group.
     */
    @JvmName("ahwsoxhpaqsoskti")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagementLockAtResourceGroupLevelPlainArgs =
        GetManagementLockAtResourceGroupLevelPlainArgs(
            lockName = lockName ?: throw PulumiNullFieldException("lockName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
