@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetManagementLockAtResourceLevelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lockName The name of lock.
 * @property parentResourcePath An extra path parameter needed in some services, like SQL Databases.
 * @property resourceGroupName The name of the resource group.
 * @property resourceName The name of the resource.
 * @property resourceProviderNamespace The namespace of the resource provider.
 * @property resourceType The type of the resource.
 */
public data class GetManagementLockAtResourceLevelPlainArgs(
    public val lockName: String,
    public val parentResourcePath: String,
    public val resourceGroupName: String,
    public val resourceName: String,
    public val resourceProviderNamespace: String,
    public val resourceType: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetManagementLockAtResourceLevelPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.GetManagementLockAtResourceLevelPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetManagementLockAtResourceLevelPlainArgs.builder()
            .lockName(lockName.let({ args0 -> args0 }))
            .parentResourcePath(parentResourcePath.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .resourceProviderNamespace(resourceProviderNamespace.let({ args0 -> args0 }))
            .resourceType(resourceType.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagementLockAtResourceLevelPlainArgs].
 */
@PulumiTagMarker
public class GetManagementLockAtResourceLevelPlainArgsBuilder internal constructor() {
    private var lockName: String? = null

    private var parentResourcePath: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var resourceProviderNamespace: String? = null

    private var resourceType: String? = null

    /**
     * @param value The name of lock.
     */
    @JvmName("gcqqqjlpqsofjcqp")
    public suspend fun lockName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.lockName = mapped
    }

    /**
     * @param value An extra path parameter needed in some services, like SQL Databases.
     */
    @JvmName("gxsyhshtuowsflcg")
    public suspend fun parentResourcePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parentResourcePath = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("aqkfteosywfsrgmd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("rjdpdeeoddkmebiv")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value The namespace of the resource provider.
     */
    @JvmName("rdydfqlvqdydbkem")
    public suspend fun resourceProviderNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceProviderNamespace = mapped
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("rsxcgnrepwfsprci")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    internal fun build(): GetManagementLockAtResourceLevelPlainArgs =
        GetManagementLockAtResourceLevelPlainArgs(
            lockName = lockName ?: throw PulumiNullFieldException("lockName"),
            parentResourcePath = parentResourcePath ?: throw PulumiNullFieldException("parentResourcePath"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
            resourceProviderNamespace = resourceProviderNamespace ?: throw
                PulumiNullFieldException("resourceProviderNamespace"),
            resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        )
}
