@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionAtManagementGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managementGroupId The ID of the management group.
 * @property policySetDefinitionName The name of the policy set definition to get.
 */
public data class GetPolicySetDefinitionAtManagementGroupPlainArgs(
    public val managementGroupId: String,
    public val policySetDefinitionName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionAtManagementGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionAtManagementGroupPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionAtManagementGroupPlainArgs.builder()
            .managementGroupId(managementGroupId.let({ args0 -> args0 }))
            .policySetDefinitionName(policySetDefinitionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicySetDefinitionAtManagementGroupPlainArgs].
 */
@PulumiTagMarker
public class GetPolicySetDefinitionAtManagementGroupPlainArgsBuilder internal constructor() {
    private var managementGroupId: String? = null

    private var policySetDefinitionName: String? = null

    /**
     * @param value The ID of the management group.
     */
    @JvmName("cwsyqflhyeqiguoa")
    public suspend fun managementGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupId = mapped
    }

    /**
     * @param value The name of the policy set definition to get.
     */
    @JvmName("tbpqsmoihiwconio")
    public suspend fun policySetDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policySetDefinitionName = mapped
    }

    internal fun build(): GetPolicySetDefinitionAtManagementGroupPlainArgs =
        GetPolicySetDefinitionAtManagementGroupPlainArgs(
            managementGroupId = managementGroupId ?: throw PulumiNullFieldException("managementGroupId"),
            policySetDefinitionName = policySetDefinitionName ?: throw
                PulumiNullFieldException("policySetDefinitionName"),
        )
}
