@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetRoleAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property roleAssignmentName The name of the role assignment. It can be any valid GUID.
 * @property scope The scope of the operation or resource. Valid scopes are: subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
 * @property tenantId Tenant ID for cross-tenant request
 */
public data class GetRoleAssignmentPlainArgs(
    public val roleAssignmentName: String,
    public val scope: String,
    public val tenantId: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetRoleAssignmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.GetRoleAssignmentPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetRoleAssignmentPlainArgs.builder()
            .roleAssignmentName(roleAssignmentName.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 }))
            .tenantId(tenantId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRoleAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetRoleAssignmentPlainArgsBuilder internal constructor() {
    private var roleAssignmentName: String? = null

    private var scope: String? = null

    private var tenantId: String? = null

    /**
     * @param value The name of the role assignment. It can be any valid GUID.
     */
    @JvmName("gvqgsfogfavtwdkv")
    public suspend fun roleAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.roleAssignmentName = mapped
    }

    /**
     * @param value The scope of the operation or resource. Valid scopes are: subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     */
    @JvmName("unhhsqwleohvxfac")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    /**
     * @param value Tenant ID for cross-tenant request
     */
    @JvmName("rnjvtskbxdeflkif")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tenantId = mapped
    }

    internal fun build(): GetRoleAssignmentPlainArgs = GetRoleAssignmentPlainArgs(
        roleAssignmentName = roleAssignmentName ?: throw PulumiNullFieldException("roleAssignmentName"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
        tenantId = tenantId,
    )
}
