@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetVariableValuePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property variableName The name of the variable to operate on.
 * @property variableValueName The name of the variable value to operate on.
 */
public data class GetVariableValuePlainArgs(
    public val variableName: String,
    public val variableValueName: String,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetVariableValuePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.GetVariableValuePlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetVariableValuePlainArgs.builder()
            .variableName(variableName.let({ args0 -> args0 }))
            .variableValueName(variableValueName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVariableValuePlainArgs].
 */
@PulumiTagMarker
public class GetVariableValuePlainArgsBuilder internal constructor() {
    private var variableName: String? = null

    private var variableValueName: String? = null

    /**
     * @param value The name of the variable to operate on.
     */
    @JvmName("uqbisbswmemdnavy")
    public suspend fun variableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.variableName = mapped
    }

    /**
     * @param value The name of the variable value to operate on.
     */
    @JvmName("lucbgjfwkgumicfx")
    public suspend fun variableValueName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.variableValueName = mapped
    }

    internal fun build(): GetVariableValuePlainArgs = GetVariableValuePlainArgs(
        variableName = variableName ?: throw PulumiNullFieldException("variableName"),
        variableValueName = variableValueName ?: throw PulumiNullFieldException("variableValueName"),
    )
}
