@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.PolicyDefinitionReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The policy definition reference.
 * @property groupNames The name of the groups that this policy definition reference belongs to.
 * @property parameters The parameter values for the referenced policy rule. The keys are the parameter names.
 * @property policyDefinitionId The ID of the policy definition or policy set definition.
 * @property policyDefinitionReferenceId A unique id (within the policy set definition) for this policy definition reference.
 */
public data class PolicyDefinitionReferenceArgs(
    public val groupNames: Output<List<String>>? = null,
    public val parameters: Output<Map<String, ParameterValuesValueArgs>>? = null,
    public val policyDefinitionId: Output<String>,
    public val policyDefinitionReferenceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.PolicyDefinitionReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.PolicyDefinitionReferenceArgs =
        com.pulumi.azurenative.authorization.inputs.PolicyDefinitionReferenceArgs.builder()
            .groupNames(groupNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .policyDefinitionId(policyDefinitionId.applyValue({ args0 -> args0 }))
            .policyDefinitionReferenceId(policyDefinitionReferenceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyDefinitionReferenceArgs].
 */
@PulumiTagMarker
public class PolicyDefinitionReferenceArgsBuilder internal constructor() {
    private var groupNames: Output<List<String>>? = null

    private var parameters: Output<Map<String, ParameterValuesValueArgs>>? = null

    private var policyDefinitionId: Output<String>? = null

    private var policyDefinitionReferenceId: Output<String>? = null

    /**
     * @param value The name of the groups that this policy definition reference belongs to.
     */
    @JvmName("hiogkamqrgpdboxe")
    public suspend fun groupNames(`value`: Output<List<String>>) {
        this.groupNames = value
    }

    @JvmName("fgcomvvojwrrponi")
    public suspend fun groupNames(vararg values: Output<String>) {
        this.groupNames = Output.all(values.asList())
    }

    /**
     * @param values The name of the groups that this policy definition reference belongs to.
     */
    @JvmName("qcybygnygfiwuraj")
    public suspend fun groupNames(values: List<Output<String>>) {
        this.groupNames = Output.all(values)
    }

    /**
     * @param value The parameter values for the referenced policy rule. The keys are the parameter names.
     */
    @JvmName("tpalojnpweotjaaq")
    public suspend fun parameters(`value`: Output<Map<String, ParameterValuesValueArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The ID of the policy definition or policy set definition.
     */
    @JvmName("artppklusxcfwfdv")
    public suspend fun policyDefinitionId(`value`: Output<String>) {
        this.policyDefinitionId = value
    }

    /**
     * @param value A unique id (within the policy set definition) for this policy definition reference.
     */
    @JvmName("jgipufobxnmdhjbx")
    public suspend fun policyDefinitionReferenceId(`value`: Output<String>) {
        this.policyDefinitionReferenceId = value
    }

    /**
     * @param value The name of the groups that this policy definition reference belongs to.
     */
    @JvmName("hlxwghhcwxekstla")
    public suspend fun groupNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupNames = mapped
    }

    /**
     * @param values The name of the groups that this policy definition reference belongs to.
     */
    @JvmName("wcrtlwubbsrdxbwm")
    public suspend fun groupNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupNames = mapped
    }

    /**
     * @param value The parameter values for the referenced policy rule. The keys are the parameter names.
     */
    @JvmName("opxnyyeftfupvyxb")
    public suspend fun parameters(`value`: Map<String, ParameterValuesValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameter values for the referenced policy rule. The keys are the parameter names.
     */
    @JvmName("ldnxexufjdwqqcmb")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterValuesValueArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterValuesValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameter values for the referenced policy rule. The keys are the parameter names.
     */
    @JvmName("ngkswsiwfkmglcds")
    public fun parameters(vararg values: Pair<String, ParameterValuesValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The ID of the policy definition or policy set definition.
     */
    @JvmName("sjhdcgssqxiduuky")
    public suspend fun policyDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyDefinitionId = mapped
    }

    /**
     * @param value A unique id (within the policy set definition) for this policy definition reference.
     */
    @JvmName("yrtbckdmfeectedv")
    public suspend fun policyDefinitionReferenceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionReferenceId = mapped
    }

    internal fun build(): PolicyDefinitionReferenceArgs = PolicyDefinitionReferenceArgs(
        groupNames = groupNames,
        parameters = parameters,
        policyDefinitionId = policyDefinitionId ?: throw PulumiNullFieldException("policyDefinitionId"),
        policyDefinitionReferenceId = policyDefinitionReferenceId,
    )
}
