@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.PolicyVariableColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The variable column.
 * @property columnName The name of this policy variable column.
 */
public data class PolicyVariableColumnArgs(
    public val columnName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.PolicyVariableColumnArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.PolicyVariableColumnArgs =
        com.pulumi.azurenative.authorization.inputs.PolicyVariableColumnArgs.builder()
            .columnName(columnName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyVariableColumnArgs].
 */
@PulumiTagMarker
public class PolicyVariableColumnArgsBuilder internal constructor() {
    private var columnName: Output<String>? = null

    /**
     * @param value The name of this policy variable column.
     */
    @JvmName("bfryruqhrsgiddga")
    public suspend fun columnName(`value`: Output<String>) {
        this.columnName = value
    }

    /**
     * @param value The name of this policy variable column.
     */
    @JvmName("xpgrubxoqsbtouuk")
    public suspend fun columnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnName = mapped
    }

    internal fun build(): PolicyVariableColumnArgs = PolicyVariableColumnArgs(
        columnName = columnName ?: throw PulumiNullFieldException("columnName"),
    )
}
