@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Descriptor for what needs to be reviewed
 * @property assignmentState The role assignment state eligible/active to review
 * @property excludeResourceId This is used to indicate the resource id(s) to exclude
 * @property excludeRoleDefinitionId This is used to indicate the role definition id(s) to exclude
 * @property expandNestedMemberships Flag to indicate whether to expand nested memberships or not.
 * @property inactiveDuration Duration users are inactive for. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
 * @property includeAccessBelowResource Flag to indicate whether to expand nested memberships or not.
 * @property includeInheritedAccess Flag to indicate whether to expand nested memberships or not.
 * @property principalType The identity type user/servicePrincipal to review
 * @property resourceId ResourceId in which this review is getting created
 * @property roleDefinitionId This is used to indicate the role being reviewed
 */
public data class AccessReviewScopeResponse(
    public val assignmentState: String,
    public val excludeResourceId: String? = null,
    public val excludeRoleDefinitionId: String? = null,
    public val expandNestedMemberships: Boolean? = null,
    public val inactiveDuration: String? = null,
    public val includeAccessBelowResource: Boolean? = null,
    public val includeInheritedAccess: Boolean? = null,
    public val principalType: String,
    public val resourceId: String,
    public val roleDefinitionId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.AccessReviewScopeResponse):
            AccessReviewScopeResponse = AccessReviewScopeResponse(
            assignmentState = javaType.assignmentState(),
            excludeResourceId = javaType.excludeResourceId().map({ args0 -> args0 }).orElse(null),
            excludeRoleDefinitionId = javaType.excludeRoleDefinitionId().map({ args0 -> args0 }).orElse(null),
            expandNestedMemberships = javaType.expandNestedMemberships().map({ args0 -> args0 }).orElse(null),
            inactiveDuration = javaType.inactiveDuration().map({ args0 -> args0 }).orElse(null),
            includeAccessBelowResource = javaType.includeAccessBelowResource().map({ args0 ->
                args0
            }).orElse(null),
            includeInheritedAccess = javaType.includeInheritedAccess().map({ args0 -> args0 }).orElse(null),
            principalType = javaType.principalType(),
            resourceId = javaType.resourceId(),
            roleDefinitionId = javaType.roleDefinitionId(),
        )
    }
}
