@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Role Assignments
 * @property condition The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft&#46;Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'
 * @property conditionVersion Version of the condition. Currently the only accepted value is '2.0'
 * @property createdBy Id of the user who created the assignment
 * @property createdOn Time it was created
 * @property delegatedManagedIdentityResourceId Id of the delegated managed identity resource
 * @property description Description of role assignment
 * @property id The role assignment ID.
 * @property name The role assignment name.
 * @property principalId The principal ID.
 * @property principalType The principal type of the assigned principal ID.
 * @property roleDefinitionId The role definition ID.
 * @property scope The role assignment scope.
 * @property type The role assignment type.
 * @property updatedBy Id of the user who updated the assignment
 * @property updatedOn Time it was updated
 */
public data class GetRoleAssignmentResult(
    public val condition: String? = null,
    public val conditionVersion: String? = null,
    public val createdBy: String,
    public val createdOn: String,
    public val delegatedManagedIdentityResourceId: String? = null,
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val principalId: String,
    public val principalType: String? = null,
    public val roleDefinitionId: String,
    public val scope: String,
    public val type: String,
    public val updatedBy: String,
    public val updatedOn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.GetRoleAssignmentResult):
            GetRoleAssignmentResult = GetRoleAssignmentResult(
            condition = javaType.condition().map({ args0 -> args0 }).orElse(null),
            conditionVersion = javaType.conditionVersion().map({ args0 -> args0 }).orElse(null),
            createdBy = javaType.createdBy(),
            createdOn = javaType.createdOn(),
            delegatedManagedIdentityResourceId = javaType.delegatedManagedIdentityResourceId().map({ args0 ->
                args0
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            principalId = javaType.principalId(),
            principalType = javaType.principalType().map({ args0 -> args0 }).orElse(null),
            roleDefinitionId = javaType.roleDefinitionId(),
            scope = javaType.scope(),
            type = javaType.type(),
            updatedBy = javaType.updatedBy(),
            updatedOn = javaType.updatedOn(),
        )
    }
}
