@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Access Review History Definition.
 * @property createdDateTime Date time when history definition was created
 * @property decisions Collection of review decisions which the history data should be filtered on. For example if Approve and Deny are supplied the data will only contain review results in which the decision maker approved or denied a review request.
 * @property displayName The display name for the history definition.
 * @property endDate The DateTime when the review is scheduled to end. Required if type is endDate
 * @property id The access review history definition id.
 * @property instances Set of access review history instances for this history definition.
 * @property interval The interval for recurrence. For a quarterly review, the interval is 3 for type : absoluteMonthly.
 * @property name The access review history definition unique id.
 * @property numberOfOccurrences The number of times to repeat the access review. Required and must be positive if type is numbered.
 * @property principalId The identity id
 * @property principalName The identity display name
 * @property principalType The identity type : user/servicePrincipal
 * @property reviewHistoryPeriodEndDateTime Date time used when selecting review data, all reviews included in data end on or before this date. For use only with one-time/non-recurring reports.
 * @property reviewHistoryPeriodStartDateTime Date time used when selecting review data, all reviews included in data start on or after this date. For use only with one-time/non-recurring reports.
 * @property scopes A collection of scopes used when selecting review history data
 * @property startDate The DateTime when the review is scheduled to be start. This could be a date in the future. Required on create.
 * @property status This read-only field specifies the of the requested review history data. This is either requested, in-progress, done or error.
 * @property type The resource type.
 * @property userPrincipalName The user principal name(if valid)
 */
public data class GetScopeAccessReviewHistoryDefinitionByIdResult(
    public val createdDateTime: String,
    public val decisions: List<String>? = null,
    public val displayName: String? = null,
    public val endDate: String? = null,
    public val id: String,
    public val instances: List<AccessReviewHistoryInstanceResponse>? = null,
    public val interval: Int? = null,
    public val name: String,
    public val numberOfOccurrences: Int? = null,
    public val principalId: String,
    public val principalName: String,
    public val principalType: String,
    public val reviewHistoryPeriodEndDateTime: String,
    public val reviewHistoryPeriodStartDateTime: String,
    public val scopes: List<AccessReviewScopeResponse>? = null,
    public val startDate: String? = null,
    public val status: String,
    public val type: String,
    public val userPrincipalName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.GetScopeAccessReviewHistoryDefinitionByIdResult):
            GetScopeAccessReviewHistoryDefinitionByIdResult =
            GetScopeAccessReviewHistoryDefinitionByIdResult(
                createdDateTime = javaType.createdDateTime(),
                decisions = javaType.decisions().map({ args0 -> args0 }),
                displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
                endDate = javaType.endDate().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                instances = javaType.instances().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.authorization.kotlin.outputs.AccessReviewHistoryInstanceResponse.Companion.toKotlin(args0)
                    })
                }),
                interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                numberOfOccurrences = javaType.numberOfOccurrences().map({ args0 -> args0 }).orElse(null),
                principalId = javaType.principalId(),
                principalName = javaType.principalName(),
                principalType = javaType.principalType(),
                reviewHistoryPeriodEndDateTime = javaType.reviewHistoryPeriodEndDateTime(),
                reviewHistoryPeriodStartDateTime = javaType.reviewHistoryPeriodStartDateTime(),
                scopes = javaType.scopes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.authorization.kotlin.outputs.AccessReviewScopeResponse.Companion.toKotlin(args0)
                    })
                }),
                startDate = javaType.startDate().map({ args0 -> args0 }).orElse(null),
                status = javaType.status(),
                type = javaType.type(),
                userPrincipalName = javaType.userPrincipalName(),
            )
    }
}
