@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Access Review Schedule Definition.
 * @property assignmentState The role assignment state eligible/active to review
 * @property autoApplyDecisionsEnabled Flag to indicate whether auto-apply capability, to automatically change the target object access resource, is enabled. If not enabled, a user must, after the review completes, apply the access review.
 * @property backupReviewers This is the collection of backup reviewers.
 * @property defaultDecision This specifies the behavior for the autoReview feature when an access review completes.
 * @property defaultDecisionEnabled Flag to indicate whether reviewers are required to provide a justification when reviewing access.
 * @property descriptionForAdmins The description provided by the access review creator and visible to admins.
 * @property descriptionForReviewers The description provided by the access review creator to be shown to reviewers.
 * @property displayName The display name for the schedule definition.
 * @property endDate The DateTime when the review is scheduled to end. Required if type is endDate
 * @property excludeResourceId This is used to indicate the resource id(s) to exclude
 * @property excludeRoleDefinitionId This is used to indicate the role definition id(s) to exclude
 * @property expandNestedMemberships Flag to indicate whether to expand nested memberships or not.
 * @property id The access review schedule definition id.
 * @property inactiveDuration Duration users are inactive for. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
 * @property includeAccessBelowResource Flag to indicate whether to expand nested memberships or not.
 * @property includeInheritedAccess Flag to indicate whether to expand nested memberships or not.
 * @property instanceDurationInDays The duration in days for an instance.
 * @property instances This is the collection of instances returned when one does an expand on it.
 * @property interval The interval for recurrence. For a quarterly review, the interval is 3 for type : absoluteMonthly.
 * @property justificationRequiredOnApproval Flag to indicate whether the reviewer is required to pass justification when recording a decision.
 * @property mailNotificationsEnabled Flag to indicate whether sending mails to reviewers and the review creator is enabled.
 * @property name The access review schedule definition unique id.
 * @property numberOfOccurrences The number of times to repeat the access review. Required and must be positive if type is numbered.
 * @property principalId The identity id
 * @property principalName The identity display name
 * @property principalType The identity type user/servicePrincipal to review
 * @property recommendationLookBackDuration Recommendations for access reviews are calculated by looking back at 30 days of data(w.r.t the start date of the review) by default. However, in some scenarios, customers want to change how far back to look at and want to configure 60 days, 90 days, etc. instead. This setting allows customers to configure this duration. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
 * @property recommendationsEnabled Flag to indicate whether showing recommendations to reviewers is enabled.
 * @property reminderNotificationsEnabled Flag to indicate whether sending reminder emails to reviewers are enabled.
 * @property resourceId ResourceId in which this review is getting created
 * @property reviewers This is the collection of reviewers.
 * @property reviewersType This field specifies the type of reviewers for a review. Usually for a review, reviewers are explicitly assigned. However, in some cases, the reviewers may not be assigned and instead be chosen dynamically. For example managers review or self review.
 * @property roleDefinitionId This is used to indicate the role being reviewed
 * @property startDate The DateTime when the review is scheduled to be start. This could be a date in the future. Required on create.
 * @property status This read-only field specifies the status of an accessReview.
 * @property type The resource type.
 * @property userPrincipalName The user principal name(if valid)
 */
public data class GetScopeAccessReviewScheduleDefinitionByIdResult(
    public val assignmentState: String,
    public val autoApplyDecisionsEnabled: Boolean? = null,
    public val backupReviewers: List<AccessReviewReviewerResponse>? = null,
    public val defaultDecision: String? = null,
    public val defaultDecisionEnabled: Boolean? = null,
    public val descriptionForAdmins: String? = null,
    public val descriptionForReviewers: String? = null,
    public val displayName: String? = null,
    public val endDate: String? = null,
    public val excludeResourceId: String? = null,
    public val excludeRoleDefinitionId: String? = null,
    public val expandNestedMemberships: Boolean? = null,
    public val id: String,
    public val inactiveDuration: String? = null,
    public val includeAccessBelowResource: Boolean? = null,
    public val includeInheritedAccess: Boolean? = null,
    public val instanceDurationInDays: Int? = null,
    public val instances: List<AccessReviewInstanceResponse>? = null,
    public val interval: Int? = null,
    public val justificationRequiredOnApproval: Boolean? = null,
    public val mailNotificationsEnabled: Boolean? = null,
    public val name: String,
    public val numberOfOccurrences: Int? = null,
    public val principalId: String,
    public val principalName: String,
    public val principalType: String,
    public val recommendationLookBackDuration: String? = null,
    public val recommendationsEnabled: Boolean? = null,
    public val reminderNotificationsEnabled: Boolean? = null,
    public val resourceId: String,
    public val reviewers: List<AccessReviewReviewerResponse>? = null,
    public val reviewersType: String,
    public val roleDefinitionId: String,
    public val startDate: String? = null,
    public val status: String,
    public val type: String,
    public val userPrincipalName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.GetScopeAccessReviewScheduleDefinitionByIdResult):
            GetScopeAccessReviewScheduleDefinitionByIdResult =
            GetScopeAccessReviewScheduleDefinitionByIdResult(
                assignmentState = javaType.assignmentState(),
                autoApplyDecisionsEnabled = javaType.autoApplyDecisionsEnabled().map({ args0 ->
                    args0
                }).orElse(null),
                backupReviewers = javaType.backupReviewers().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.authorization.kotlin.outputs.AccessReviewReviewerResponse.Companion.toKotlin(args0)
                    })
                }),
                defaultDecision = javaType.defaultDecision().map({ args0 -> args0 }).orElse(null),
                defaultDecisionEnabled = javaType.defaultDecisionEnabled().map({ args0 -> args0 }).orElse(null),
                descriptionForAdmins = javaType.descriptionForAdmins().map({ args0 -> args0 }).orElse(null),
                descriptionForReviewers = javaType.descriptionForReviewers().map({ args0 -> args0 }).orElse(null),
                displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
                endDate = javaType.endDate().map({ args0 -> args0 }).orElse(null),
                excludeResourceId = javaType.excludeResourceId().map({ args0 -> args0 }).orElse(null),
                excludeRoleDefinitionId = javaType.excludeRoleDefinitionId().map({ args0 -> args0 }).orElse(null),
                expandNestedMemberships = javaType.expandNestedMemberships().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                inactiveDuration = javaType.inactiveDuration().map({ args0 -> args0 }).orElse(null),
                includeAccessBelowResource = javaType.includeAccessBelowResource().map({ args0 ->
                    args0
                }).orElse(null),
                includeInheritedAccess = javaType.includeInheritedAccess().map({ args0 -> args0 }).orElse(null),
                instanceDurationInDays = javaType.instanceDurationInDays().map({ args0 -> args0 }).orElse(null),
                instances = javaType.instances().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.authorization.kotlin.outputs.AccessReviewInstanceResponse.Companion.toKotlin(args0)
                    })
                }),
                interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
                justificationRequiredOnApproval = javaType.justificationRequiredOnApproval().map({ args0 ->
                    args0
                }).orElse(null),
                mailNotificationsEnabled = javaType.mailNotificationsEnabled().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                numberOfOccurrences = javaType.numberOfOccurrences().map({ args0 -> args0 }).orElse(null),
                principalId = javaType.principalId(),
                principalName = javaType.principalName(),
                principalType = javaType.principalType(),
                recommendationLookBackDuration = javaType.recommendationLookBackDuration().map({ args0 ->
                    args0
                }).orElse(null),
                recommendationsEnabled = javaType.recommendationsEnabled().map({ args0 -> args0 }).orElse(null),
                reminderNotificationsEnabled = javaType.reminderNotificationsEnabled().map({ args0 ->
                    args0
                }).orElse(null),
                resourceId = javaType.resourceId(),
                reviewers = javaType.reviewers().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.authorization.kotlin.outputs.AccessReviewReviewerResponse.Companion.toKotlin(args0)
                    })
                }),
                reviewersType = javaType.reviewersType(),
                roleDefinitionId = javaType.roleDefinitionId(),
                startDate = javaType.startDate().map({ args0 -> args0 }).orElse(null),
                status = javaType.status(),
                type = javaType.type(),
                userPrincipalName = javaType.userPrincipalName(),
            )
    }
}
