@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of role definition
 * @property displayName Display name of the role definition
 * @property id Id of the role definition
 * @property type Type of the role definition
 */
public data class PolicyAssignmentPropertiesResponseRoleDefinition(
    public val displayName: String? = null,
    public val id: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.PolicyAssignmentPropertiesResponseRoleDefinition):
            PolicyAssignmentPropertiesResponseRoleDefinition =
            PolicyAssignmentPropertiesResponseRoleDefinition(
                displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
            )
    }
}
