@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The policy definition group.
 * @property additionalMetadataId A resource ID of a resource that contains additional metadata about the group.
 * @property category The group's category.
 * @property description The group's description.
 * @property displayName The group's display name.
 * @property name The name of the group.
 */
public data class PolicyDefinitionGroupResponse(
    public val additionalMetadataId: String? = null,
    public val category: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.PolicyDefinitionGroupResponse):
            PolicyDefinitionGroupResponse = PolicyDefinitionGroupResponse(
            additionalMetadataId = javaType.additionalMetadataId().map({ args0 -> args0 }).orElse(null),
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
