@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The role management policy authentication context rule.
 * @property claimValue The claim value.
 * @property id The id of the rule.
 * @property isEnabled The value indicating if rule is enabled.
 * @property ruleType The type of rule
 * Expected value is 'RoleManagementPolicyAuthenticationContextRule'.
 * @property target The target of the current rule.
 */
public data class RoleManagementPolicyAuthenticationContextRuleResponse(
    public val claimValue: String? = null,
    public val id: String? = null,
    public val isEnabled: Boolean? = null,
    public val ruleType: String,
    public val target: RoleManagementPolicyRuleTargetResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.RoleManagementPolicyAuthenticationContextRuleResponse):
            RoleManagementPolicyAuthenticationContextRuleResponse =
            RoleManagementPolicyAuthenticationContextRuleResponse(
                claimValue = javaType.claimValue().map({ args0 -> args0 }).orElse(null),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
                ruleType = javaType.ruleType(),
                target = javaType.target().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.authorization.kotlin.outputs.RoleManagementPolicyRuleTargetResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
