@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin

import com.pulumi.azurenative.automanage.AutomanageFunctions.getAccountPlain
import com.pulumi.azurenative.automanage.AutomanageFunctions.getConfigurationProfileAssignmentPlain
import com.pulumi.azurenative.automanage.AutomanageFunctions.getConfigurationProfileHCIAssignmentPlain
import com.pulumi.azurenative.automanage.AutomanageFunctions.getConfigurationProfileHCRPAssignmentPlain
import com.pulumi.azurenative.automanage.AutomanageFunctions.getConfigurationProfilePlain
import com.pulumi.azurenative.automanage.AutomanageFunctions.getConfigurationProfilePreferencePlain
import com.pulumi.azurenative.automanage.AutomanageFunctions.getConfigurationProfilesVersionPlain
import com.pulumi.azurenative.automanage.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.automanage.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.automanage.kotlin.inputs.GetConfigurationProfileAssignmentPlainArgs
import com.pulumi.azurenative.automanage.kotlin.inputs.GetConfigurationProfileAssignmentPlainArgsBuilder
import com.pulumi.azurenative.automanage.kotlin.inputs.GetConfigurationProfileHCIAssignmentPlainArgs
import com.pulumi.azurenative.automanage.kotlin.inputs.GetConfigurationProfileHCIAssignmentPlainArgsBuilder
import com.pulumi.azurenative.automanage.kotlin.inputs.GetConfigurationProfileHCRPAssignmentPlainArgs
import com.pulumi.azurenative.automanage.kotlin.inputs.GetConfigurationProfileHCRPAssignmentPlainArgsBuilder
import com.pulumi.azurenative.automanage.kotlin.inputs.GetConfigurationProfilePlainArgs
import com.pulumi.azurenative.automanage.kotlin.inputs.GetConfigurationProfilePlainArgsBuilder
import com.pulumi.azurenative.automanage.kotlin.inputs.GetConfigurationProfilePreferencePlainArgs
import com.pulumi.azurenative.automanage.kotlin.inputs.GetConfigurationProfilePreferencePlainArgsBuilder
import com.pulumi.azurenative.automanage.kotlin.inputs.GetConfigurationProfilesVersionPlainArgs
import com.pulumi.azurenative.automanage.kotlin.inputs.GetConfigurationProfilesVersionPlainArgsBuilder
import com.pulumi.azurenative.automanage.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.automanage.kotlin.outputs.GetConfigurationProfileAssignmentResult
import com.pulumi.azurenative.automanage.kotlin.outputs.GetConfigurationProfileHCIAssignmentResult
import com.pulumi.azurenative.automanage.kotlin.outputs.GetConfigurationProfileHCRPAssignmentResult
import com.pulumi.azurenative.automanage.kotlin.outputs.GetConfigurationProfilePreferenceResult
import com.pulumi.azurenative.automanage.kotlin.outputs.GetConfigurationProfileResult
import com.pulumi.azurenative.automanage.kotlin.outputs.GetConfigurationProfilesVersionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.automanage.kotlin.outputs.GetAccountResult.Companion.toKotlin as getAccountResultToKotlin
import com.pulumi.azurenative.automanage.kotlin.outputs.GetConfigurationProfileAssignmentResult.Companion.toKotlin as getConfigurationProfileAssignmentResultToKotlin
import com.pulumi.azurenative.automanage.kotlin.outputs.GetConfigurationProfileHCIAssignmentResult.Companion.toKotlin as getConfigurationProfileHCIAssignmentResultToKotlin
import com.pulumi.azurenative.automanage.kotlin.outputs.GetConfigurationProfileHCRPAssignmentResult.Companion.toKotlin as getConfigurationProfileHCRPAssignmentResultToKotlin
import com.pulumi.azurenative.automanage.kotlin.outputs.GetConfigurationProfilePreferenceResult.Companion.toKotlin as getConfigurationProfilePreferenceResultToKotlin
import com.pulumi.azurenative.automanage.kotlin.outputs.GetConfigurationProfileResult.Companion.toKotlin as getConfigurationProfileResultToKotlin
import com.pulumi.azurenative.automanage.kotlin.outputs.GetConfigurationProfilesVersionResult.Companion.toKotlin as getConfigurationProfilesVersionResultToKotlin

public object AutomanageFunctions {
    /**
     * Get information about a Automanage account
     * Azure REST API version: 2020-06-30-preview.
     * @param argument null
     * @return Definition of the Automanage account.
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param accountName The Automanage account name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Definition of the Automanage account.
     */
    public suspend fun getAccount(accountName: String, resourceGroupName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automanage&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return Definition of the Automanage account.
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit):
        GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountResultToKotlin(getAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information about a configuration profile
     * Azure REST API version: 2022-05-04.
     * @param argument null
     * @return Definition of the configuration profile.
     */
    public suspend fun getConfigurationProfile(argument: GetConfigurationProfilePlainArgs):
        GetConfigurationProfileResult =
        getConfigurationProfileResultToKotlin(getConfigurationProfilePlain(argument.toJava()).await())

    /**
     * @see [getConfigurationProfile].
     * @param configurationProfileName The configuration profile name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Definition of the configuration profile.
     */
    public suspend fun getConfigurationProfile(
        configurationProfileName: String,
        resourceGroupName: String,
    ): GetConfigurationProfileResult {
        val argument = GetConfigurationProfilePlainArgs(
            configurationProfileName = configurationProfileName,
            resourceGroupName = resourceGroupName,
        )
        return getConfigurationProfileResultToKotlin(getConfigurationProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationProfile].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automanage&#46;kotlin&#46;inputs&#46;GetConfigurationProfilePlainArgs].
     * @return Definition of the configuration profile.
     */
    public suspend
    fun getConfigurationProfile(argument: suspend GetConfigurationProfilePlainArgsBuilder.() -> Unit):
        GetConfigurationProfileResult {
        val builder = GetConfigurationProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationProfileResultToKotlin(getConfigurationProfilePlain(builtArgument.toJava()).await())
    }

    /**
     * Get information about a configuration profile assignment
     * Azure REST API version: 2022-05-04.
     * @param argument null
     * @return Configuration profile assignment is an association between a VM and automanage profile configuration.
     */
    public suspend
    fun getConfigurationProfileAssignment(argument: GetConfigurationProfileAssignmentPlainArgs):
        GetConfigurationProfileAssignmentResult =
        getConfigurationProfileAssignmentResultToKotlin(getConfigurationProfileAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getConfigurationProfileAssignment].
     * @param configurationProfileAssignmentName The configuration profile assignment name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the virtual machine.
     * @return Configuration profile assignment is an association between a VM and automanage profile configuration.
     */
    public suspend fun getConfigurationProfileAssignment(
        configurationProfileAssignmentName: String,
        resourceGroupName: String,
        vmName: String,
    ): GetConfigurationProfileAssignmentResult {
        val argument = GetConfigurationProfileAssignmentPlainArgs(
            configurationProfileAssignmentName = configurationProfileAssignmentName,
            resourceGroupName = resourceGroupName,
            vmName = vmName,
        )
        return getConfigurationProfileAssignmentResultToKotlin(getConfigurationProfileAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationProfileAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automanage&#46;kotlin&#46;inputs&#46;GetConfigurationProfileAssignmentPlainArgs].
     * @return Configuration profile assignment is an association between a VM and automanage profile configuration.
     */
    public suspend
    fun getConfigurationProfileAssignment(argument: suspend GetConfigurationProfileAssignmentPlainArgsBuilder.() -> Unit):
        GetConfigurationProfileAssignmentResult {
        val builder = GetConfigurationProfileAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationProfileAssignmentResultToKotlin(getConfigurationProfileAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information about a configuration profile assignment
     * Azure REST API version: 2022-05-04.
     * @param argument null
     * @return Configuration profile assignment is an association between a VM and automanage profile configuration.
     */
    public suspend
    fun getConfigurationProfileHCIAssignment(argument: GetConfigurationProfileHCIAssignmentPlainArgs):
        GetConfigurationProfileHCIAssignmentResult =
        getConfigurationProfileHCIAssignmentResultToKotlin(getConfigurationProfileHCIAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getConfigurationProfileHCIAssignment].
     * @param clusterName The name of the Arc machine.
     * @param configurationProfileAssignmentName The configuration profile assignment name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Configuration profile assignment is an association between a VM and automanage profile configuration.
     */
    public suspend fun getConfigurationProfileHCIAssignment(
        clusterName: String,
        configurationProfileAssignmentName: String,
        resourceGroupName: String,
    ): GetConfigurationProfileHCIAssignmentResult {
        val argument = GetConfigurationProfileHCIAssignmentPlainArgs(
            clusterName = clusterName,
            configurationProfileAssignmentName = configurationProfileAssignmentName,
            resourceGroupName = resourceGroupName,
        )
        return getConfigurationProfileHCIAssignmentResultToKotlin(getConfigurationProfileHCIAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationProfileHCIAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automanage&#46;kotlin&#46;inputs&#46;GetConfigurationProfileHCIAssignmentPlainArgs].
     * @return Configuration profile assignment is an association between a VM and automanage profile configuration.
     */
    public suspend
    fun getConfigurationProfileHCIAssignment(argument: suspend GetConfigurationProfileHCIAssignmentPlainArgsBuilder.() -> Unit):
        GetConfigurationProfileHCIAssignmentResult {
        val builder = GetConfigurationProfileHCIAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationProfileHCIAssignmentResultToKotlin(getConfigurationProfileHCIAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information about a configuration profile assignment
     * Azure REST API version: 2022-05-04.
     * @param argument null
     * @return Configuration profile assignment is an association between a VM and automanage profile configuration.
     */
    public suspend
    fun getConfigurationProfileHCRPAssignment(argument: GetConfigurationProfileHCRPAssignmentPlainArgs):
        GetConfigurationProfileHCRPAssignmentResult =
        getConfigurationProfileHCRPAssignmentResultToKotlin(getConfigurationProfileHCRPAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getConfigurationProfileHCRPAssignment].
     * @param configurationProfileAssignmentName The configuration profile assignment name.
     * @param machineName The name of the Arc machine.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Configuration profile assignment is an association between a VM and automanage profile configuration.
     */
    public suspend fun getConfigurationProfileHCRPAssignment(
        configurationProfileAssignmentName: String,
        machineName: String,
        resourceGroupName: String,
    ): GetConfigurationProfileHCRPAssignmentResult {
        val argument = GetConfigurationProfileHCRPAssignmentPlainArgs(
            configurationProfileAssignmentName = configurationProfileAssignmentName,
            machineName = machineName,
            resourceGroupName = resourceGroupName,
        )
        return getConfigurationProfileHCRPAssignmentResultToKotlin(getConfigurationProfileHCRPAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationProfileHCRPAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automanage&#46;kotlin&#46;inputs&#46;GetConfigurationProfileHCRPAssignmentPlainArgs].
     * @return Configuration profile assignment is an association between a VM and automanage profile configuration.
     */
    public suspend
    fun getConfigurationProfileHCRPAssignment(argument: suspend GetConfigurationProfileHCRPAssignmentPlainArgsBuilder.() -> Unit):
        GetConfigurationProfileHCRPAssignmentResult {
        val builder = GetConfigurationProfileHCRPAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationProfileHCRPAssignmentResultToKotlin(getConfigurationProfileHCRPAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information about a configuration profile preference
     * Azure REST API version: 2020-06-30-preview.
     * @param argument null
     * @return Definition of the configuration profile preference.
     */
    public suspend
    fun getConfigurationProfilePreference(argument: GetConfigurationProfilePreferencePlainArgs):
        GetConfigurationProfilePreferenceResult =
        getConfigurationProfilePreferenceResultToKotlin(getConfigurationProfilePreferencePlain(argument.toJava()).await())

    /**
     * @see [getConfigurationProfilePreference].
     * @param configurationProfilePreferenceName The configuration profile preference name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Definition of the configuration profile preference.
     */
    public suspend fun getConfigurationProfilePreference(
        configurationProfilePreferenceName: String,
        resourceGroupName: String,
    ): GetConfigurationProfilePreferenceResult {
        val argument = GetConfigurationProfilePreferencePlainArgs(
            configurationProfilePreferenceName = configurationProfilePreferenceName,
            resourceGroupName = resourceGroupName,
        )
        return getConfigurationProfilePreferenceResultToKotlin(getConfigurationProfilePreferencePlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationProfilePreference].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automanage&#46;kotlin&#46;inputs&#46;GetConfigurationProfilePreferencePlainArgs].
     * @return Definition of the configuration profile preference.
     */
    public suspend
    fun getConfigurationProfilePreference(argument: suspend GetConfigurationProfilePreferencePlainArgsBuilder.() -> Unit):
        GetConfigurationProfilePreferenceResult {
        val builder = GetConfigurationProfilePreferencePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationProfilePreferenceResultToKotlin(getConfigurationProfilePreferencePlain(builtArgument.toJava()).await())
    }

    /**
     * Get information about a configuration profile version
     * Azure REST API version: 2022-05-04.
     * @param argument null
     * @return Definition of the configuration profile.
     */
    public suspend
    fun getConfigurationProfilesVersion(argument: GetConfigurationProfilesVersionPlainArgs):
        GetConfigurationProfilesVersionResult =
        getConfigurationProfilesVersionResultToKotlin(getConfigurationProfilesVersionPlain(argument.toJava()).await())

    /**
     * @see [getConfigurationProfilesVersion].
     * @param configurationProfileName The configuration profile name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param versionName The configuration profile version name.
     * @return Definition of the configuration profile.
     */
    public suspend fun getConfigurationProfilesVersion(
        configurationProfileName: String,
        resourceGroupName: String,
        versionName: String,
    ): GetConfigurationProfilesVersionResult {
        val argument = GetConfigurationProfilesVersionPlainArgs(
            configurationProfileName = configurationProfileName,
            resourceGroupName = resourceGroupName,
            versionName = versionName,
        )
        return getConfigurationProfilesVersionResultToKotlin(getConfigurationProfilesVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationProfilesVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automanage&#46;kotlin&#46;inputs&#46;GetConfigurationProfilesVersionPlainArgs].
     * @return Definition of the configuration profile.
     */
    public suspend
    fun getConfigurationProfilesVersion(argument: suspend GetConfigurationProfilesVersionPlainArgsBuilder.() -> Unit):
        GetConfigurationProfilesVersionResult {
        val builder = GetConfigurationProfilesVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationProfilesVersionResultToKotlin(getConfigurationProfilesVersionPlain(builtArgument.toJava()).await())
    }
}
