@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin

import com.pulumi.azurenative.automanage.kotlin.outputs.ConfigurationProfileAssignmentPropertiesResponse
import com.pulumi.azurenative.automanage.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.automanage.kotlin.outputs.ConfigurationProfileAssignmentPropertiesResponse.Companion.toKotlin as configurationProfileAssignmentPropertiesResponseToKotlin
import com.pulumi.azurenative.automanage.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConfigurationProfileHCIAssignment].
 */
@PulumiTagMarker
public class ConfigurationProfileHCIAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationProfileHCIAssignmentArgs = ConfigurationProfileHCIAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationProfileHCIAssignmentArgsBuilder.() -> Unit) {
        val builder = ConfigurationProfileHCIAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConfigurationProfileHCIAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.automanage.ConfigurationProfileHCIAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationProfileHCIAssignment(builtJavaResource)
    }
}

/**
 * Configuration profile assignment is an association between a VM and automanage profile configuration.
 * Azure REST API version: 2022-05-04.
 * ## Example Usage
 * ### Create or update a HCI configuration profile assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationProfileHCIAssignment = new AzureNative.Automanage.ConfigurationProfileHCIAssignment("configurationProfileHCIAssignment", new()
 *     {
 *         ClusterName = "myClusterName",
 *         ConfigurationProfileAssignmentName = "default",
 *         Properties = new AzureNative.Automanage.Inputs.ConfigurationProfileAssignmentPropertiesArgs
 *         {
 *             ConfigurationProfile = "/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction",
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automanage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automanage.NewConfigurationProfileHCIAssignment(ctx, "configurationProfileHCIAssignment", &automanage.ConfigurationProfileHCIAssignmentArgs{
 * 			ClusterName:                        pulumi.String("myClusterName"),
 * 			ConfigurationProfileAssignmentName: pulumi.String("default"),
 * 			Properties: &automanage.ConfigurationProfileAssignmentPropertiesArgs{
 * 				ConfigurationProfile: pulumi.String("/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automanage.ConfigurationProfileHCIAssignment;
 * import com.pulumi.azurenative.automanage.ConfigurationProfileHCIAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationProfileHCIAssignment = new ConfigurationProfileHCIAssignment("configurationProfileHCIAssignment", ConfigurationProfileHCIAssignmentArgs.builder()
 *             .clusterName("myClusterName")
 *             .configurationProfileAssignmentName("default")
 *             .properties(Map.of("configurationProfile", "/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction"))
 *             .resourceGroupName("myResourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automanage:ConfigurationProfileHCIAssignment default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHci/clusters/{clusterName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}
 * ```
 */
public class ConfigurationProfileHCIAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.automanage.ConfigurationProfileHCIAssignment,
) : KotlinCustomResource(javaResource, ConfigurationProfileHCIAssignmentMapper) {
    /**
     * Azure resource id. Indicates if this resource is managed by another Azure resource.
     */
    public val managedBy: Output<String>
        get() = javaResource.managedBy().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the configuration profile assignment.
     */
    public val properties: Output<ConfigurationProfileAssignmentPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                configurationProfileAssignmentPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConfigurationProfileHCIAssignmentMapper :
    ResourceMapper<ConfigurationProfileHCIAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automanage.ConfigurationProfileHCIAssignment::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationProfileHCIAssignment =
        ConfigurationProfileHCIAssignment(
            javaResource as
                com.pulumi.azurenative.automanage.ConfigurationProfileHCIAssignment,
        )
}

/**
 * @see [ConfigurationProfileHCIAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationProfileHCIAssignment].
 */
public suspend fun configurationProfileHCIAssignment(
    name: String,
    block: suspend ConfigurationProfileHCIAssignmentResourceBuilder.() -> Unit,
):
    ConfigurationProfileHCIAssignment {
    val builder = ConfigurationProfileHCIAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationProfileHCIAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationProfileHCIAssignment(name: String): ConfigurationProfileHCIAssignment {
    val builder = ConfigurationProfileHCIAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
