@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin

import com.pulumi.azurenative.automanage.ConfigurationProfileHCIAssignmentArgs.builder
import com.pulumi.azurenative.automanage.kotlin.inputs.ConfigurationProfileAssignmentPropertiesArgs
import com.pulumi.azurenative.automanage.kotlin.inputs.ConfigurationProfileAssignmentPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration profile assignment is an association between a VM and automanage profile configuration.
 * Azure REST API version: 2022-05-04.
 * ## Example Usage
 * ### Create or update a HCI configuration profile assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationProfileHCIAssignment = new AzureNative.Automanage.ConfigurationProfileHCIAssignment("configurationProfileHCIAssignment", new()
 *     {
 *         ClusterName = "myClusterName",
 *         ConfigurationProfileAssignmentName = "default",
 *         Properties = new AzureNative.Automanage.Inputs.ConfigurationProfileAssignmentPropertiesArgs
 *         {
 *             ConfigurationProfile = "/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction",
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automanage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automanage.NewConfigurationProfileHCIAssignment(ctx, "configurationProfileHCIAssignment", &automanage.ConfigurationProfileHCIAssignmentArgs{
 * 			ClusterName:                        pulumi.String("myClusterName"),
 * 			ConfigurationProfileAssignmentName: pulumi.String("default"),
 * 			Properties: &automanage.ConfigurationProfileAssignmentPropertiesArgs{
 * 				ConfigurationProfile: pulumi.String("/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automanage.ConfigurationProfileHCIAssignment;
 * import com.pulumi.azurenative.automanage.ConfigurationProfileHCIAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationProfileHCIAssignment = new ConfigurationProfileHCIAssignment("configurationProfileHCIAssignment", ConfigurationProfileHCIAssignmentArgs.builder()
 *             .clusterName("myClusterName")
 *             .configurationProfileAssignmentName("default")
 *             .properties(Map.of("configurationProfile", "/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction"))
 *             .resourceGroupName("myResourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automanage:ConfigurationProfileHCIAssignment default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHci/clusters/{clusterName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}
 * ```
 * @property clusterName The name of the Arc machine.
 * @property configurationProfileAssignmentName Name of the configuration profile assignment. Only default is supported.
 * @property properties Properties of the configuration profile assignment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ConfigurationProfileHCIAssignmentArgs(
    public val clusterName: Output<String>? = null,
    public val configurationProfileAssignmentName: Output<String>? = null,
    public val properties: Output<ConfigurationProfileAssignmentPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automanage.ConfigurationProfileHCIAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.automanage.ConfigurationProfileHCIAssignmentArgs =
        com.pulumi.azurenative.automanage.ConfigurationProfileHCIAssignmentArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .configurationProfileAssignmentName(
                configurationProfileAssignmentName?.applyValue({ args0 ->
                    args0
                }),
            )
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationProfileHCIAssignmentArgs].
 */
@PulumiTagMarker
public class ConfigurationProfileHCIAssignmentArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var configurationProfileAssignmentName: Output<String>? = null

    private var properties: Output<ConfigurationProfileAssignmentPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the Arc machine.
     */
    @JvmName("lrwlpsdvwsagjgkl")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Name of the configuration profile assignment. Only default is supported.
     */
    @JvmName("feqfncebcnamkkqj")
    public suspend fun configurationProfileAssignmentName(`value`: Output<String>) {
        this.configurationProfileAssignmentName = value
    }

    /**
     * @param value Properties of the configuration profile assignment.
     */
    @JvmName("mtssfcyvxrisneht")
    public suspend fun properties(`value`: Output<ConfigurationProfileAssignmentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uprvlfaqyyghenxv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Arc machine.
     */
    @JvmName("ikiwqtnwxovtcikn")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Name of the configuration profile assignment. Only default is supported.
     */
    @JvmName("wbukujhsqurqrytv")
    public suspend fun configurationProfileAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationProfileAssignmentName = mapped
    }

    /**
     * @param value Properties of the configuration profile assignment.
     */
    @JvmName("hnigmsyjnfslwfvc")
    public suspend fun properties(`value`: ConfigurationProfileAssignmentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the configuration profile assignment.
     */
    @JvmName("uevcsxyeruesxinb")
    public suspend
    fun properties(argument: suspend ConfigurationProfileAssignmentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationProfileAssignmentPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("onhlxxvjsudlhfpx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ConfigurationProfileHCIAssignmentArgs =
        ConfigurationProfileHCIAssignmentArgs(
            clusterName = clusterName,
            configurationProfileAssignmentName = configurationProfileAssignmentName,
            properties = properties,
            resourceGroupName = resourceGroupName,
        )
}
